ORCA/M Asm65816 2.1.0

0001 0BC9              **********************************************************************
0002 0BC9              *
0003 0BC9              * File:  StartStop.asm
0004 0BC9              *
0005 0BC9              * Copyright Apple Computer, Inc. 1988-92
0006 0BC9              * All Rights Reserved
0007 0BC9              *
0008 0BC9              * by Dan Oliver & Steven Glass
0009 0BC9              *
0010 0BC9              * This file has two entry points:
0011 0BC9              *
0012 0BC9              *    StartupTools
0013 0BC9              *    ShutDownTools
0014 0BC9              *
0015 0BC9              * Change History
0016 0BC9              *
0017 0BC9              * 02 Nov 88         Dan Oliver
0018 0BC9              *
0019 0BC9              * Coding began.
0020 0BC9              *
0021 0BC9              * 08 Nov 88         Steven Glass
0022 0BC9              *
0023 0BC9              * Integrated with tool locator.  Changed order of tool loading and
0024 0BC9              * shutdown.
0025 0BC9              *
0026 0BC9              * Fixed bug for FontManager direct page allocation and startup.
0027 0BC9              *
0028 0BC9              * 09 Nov 88         Steven Glass
0029 0BC9              *
0030 0BC9              * Changed StartStop record to include flags word and dPage handle.
0031 0BC9              * Flags word can be used later to indicate whether application wants 
0032 0BC9              * certain things. (Currently no flags defined.)
0033 0BC9              *
0034 0BC9              * DPage hanndle is saved in startstop record at startup so it can
0035 0BC9              * be disposed at shutdown.
0036 0BC9              *
0037 0BC9              * Wrote central disposing routine: KillIt to dispose handles.
0038 0BC9              *
0039 0BC9              * Returned result of startstop to calling routine by always 
0040 0BC9              * copying the handle to result before exit.  This meant 
0041 0BC9              * that in the pointer case, I had to put the pointer into
0042 0BC9              * the handle to begin with.
0043 0BC9              *
0044 0BC9              * If the shutdown call is called with a handle, we dispose
0045 0BC9              * of it.
0046 0BC9              *
0047 0BC9              * 09 Dec 88         Mensch
0048 0BC9              *
0049 0BC9              * Added support for Note Synth, Note sequencer, MIDI, and ACE
0050 0BC9              * Modified addPages routine so that it allocates the proper amount of
0051 0BC9              * dpage space when the note seq and sound tools are both started up. 
0052 0BC9              * Also, the sound tools startup routine had to be modified to not be  
0053 0BC9              * called when the user wants to use the note seq.
0054 0BC9              *
0055 0BC9              * Modified Note synth shutdown and sound tools shutdown so that errors 
0056 0BC9              * are ignored. This is so that if you started them up with the noteseq
0057 0BC9              * the shutdown routine will be able to shut everything down.
0058 0BC9              *
0059 0BC9              *  01/25/89         Dan - Corrected some comments.
0060 0BC9              *
0061 0BC9              * 06 Feb 89         Steven Glass
0062 0BC9              *
0063 0BC9              * Added TL to shutdown table.
0064 0BC9              *
0065 0BC9              * 06 Feb 89         Harry Yee
0066 0BC9              *
0067 0BC9              * Fixed problem in StartTools call. If an error is encountered in starting up
0068 0BC9              * one of the toolsets the stack is not cleaned up correctly. The tool number
0069 0BC9              * is still left on the stack. If an error returns from @StartupTools then an
0070 0BC9              * extra word is pulled off the stack before branching to @errout2.
0071 0BC9              *
0072 0BC9              * 10 Feb 89         Harry Yee
0073 0BC9              *
0074 0BC9              * In StartTools, we now set the OS global system preferences so that under 
0075 0BC9              * certain circumstances, the system's Mount facility will be called to display
0076 0BC9              * a dialog asking the user to mount a specified volume. BRC #41150.
0077 0BC9              *
0078 0BC9              * 17 Feb 89         Dave Good
0079 0BC9              *
0080 0BC9              * In the start/stop record there a word for the video mode which is passed to
0081 0BC9              * qdstartup and used to determine the mouse clamps for the event manager. The
0082 0BC9              * problem is that there is a new feature in QuickDraw that allows an application
0083 0BC9              * to tell quickdraw to use shadowed memory and this feature uses the high bit
0084 0BC9              * of the video mode. I presume that we want the video mode in the start/stop
0085 0BC9              * record to be used the same way, so I masked it with $00FF in the emStartup
0086 0BC9              * code.
0087 0BC9              *
0088 0BC9              * 22 Feb 89         Steven Glass
0089 0BC9              *
0090 0BC9              * Changed call to OpenResourceFile to use new inputs.
0091 0BC9              *
0092 0BC9              * 03 Mar 89         Dan O
0093 0BC9              *
0094 0BC9              * Switched to arrow cursor before leaving StartupTools.  If QDAux was 
0095 0BC9              * started the watch cursor was being left.
0096 0BC9              *
0097 0BC9              * 14 Mar 89         Steven Glass
0098 0BC9              *
0099 0BC9              * Undid dan's fix above.
0100 0BC9              *
0101 0BC9              * 30 Mar 89         Steven Glass
0102 0BC9              *
0103 0BC9              * Make scrambler safe.  The handle to the start stop record is now
0104 0BC9              * locked before it is used.  It is unlocked just before it is 
0105 0BC9              * returned.
0106 0BC9              *
0107 0BC9              * 11 Apr 89         Steven Glass
0108 0BC9              *
0109 0BC9              * Changed tool number for misc tools.  Was listed as 2, its really 3.
0110 0BC9              *
0111 0BC9              * Made it handle all tools except 13.  Any tool not in list is assumed to have
0112 0BC9              * no startup and no direct page needs.
0113 0BC9              *
0114 0BC9              * 17-Nov-90         Dave Lyons
0115 0BC9              *
0116 0BC9              * Currently, TS2 and TS3 both use this whole file.  It might be
0117 0BC9              * possible later to optimize by having TS3 use part of the old ROM
0118 0BC9              * code.
0119 0BC9              *
0120 0BC9              * Fixed to start up MidiSynth (#35), Animation (#37) (with 0 Flags and PatchTable),
0121 0BC9              * and Media Control (#38).
0122 0BC9              *
0123 0BC9              * Bits 2-15 of startStopRefDesc (startRecFlag) are now ignored, so we can
0124 0BC9              * use them for new things later.
0125 0BC9              *
0126 0BC9              * Changed OpenResourceFile stuff to use LGetPathname2 instead of
0127 0BC9              * creating the path "1/"+GET_NAME.
0128 0BC9              *
0129 0BC9              * 19-Nov-90         Dave Lyons
0130 0BC9              *
0131 0BC9              * Defining ShutDownTools bit 2 to be "Don't turn off the graphics
0132 0BC9              * screen," which means we set bit $0100 in SetMasterSCB before calling
0133 0BC9              * QDShutDown.
0134 0BC9              *
0135 0BC9              * 20-Nov-90         Dave Lyons
0136 0BC9              *
0137 0BC9              * Changed StartQuickDraw so that it passes bit $0100 to QDStartUp
0138 0BC9              * if we're going to start up the Window Manager too.  This makes
0139 0BC9              * QD not clear the screen if it's already on.  RefreshDesktop will
0140 0BC9              * get around to clearing the screen eventually.
0141 0BC9              *
0142 0BC9              * StartWindowMgr skips the RefreshDesktop call if we're going to
0143 0BC9              * start the Menu Manager too.  StartMenu calls RefreshDesktop.
0144 0BC9              * This gives us a perfectly-smooth app-to-app transition when
0145 0BC9              * possible.
0146 0BC9              *
0147 0BC9              * 4-Dec-90          Dave Lyons
0148 0BC9              *
0149 0BC9              * AnimStartUp ModeFlag is reall a long, not a word.  Fixed.
0150 0BC9              *
0151 0BC9              * 15-Feb-91         Dave Lyons
0152 0BC9              *
0153 0BC9              * Implemented bit 0 of the StartStopRecord.Flags word to open the
0154 0BC9              * resource fork "as allowed" instead of always read-only.
0155 0BC9              *
0156 0BC9              * 17-Feb-91         Dave Lyons
0157 0BC9              *
0158 0BC9              * Changed ShutDownTools to force the leaveScreenOn bit on if it
0159 0BC9              * detects that GQuit's idea of the current application ID is the
0160 0BC9              * same as the current QuickDraw user ID (masked with $F0FF).
0161 0BC9              *
0162 0BC9              * 18-Feb-91         Dave Lyons
0163 0BC9              *
0164 0BC9              * Oops, my StartUpTools change above is really, really stupid, because
0165 0BC9              * I have no access to that bit before opening the resource file, in
0166 0BC9              * the case that the startup record is referenced by resource.
0167 0BC9              *
0168 0BC9              * Instead, StartUpTools startStopRefDesc bit 3 means to open the
0169 0BC9              * resrouce fork as-allowed.
0170 0BC9              *
0171 0BC9              * 19-Feb-91         Dave Lyons
0172 0BC9              *
0173 0BC9              * Added User ID parameter to AnimStartUp.  Oops.
0174 0BC9              *
0175 0BC9              * 21-Feb-91         Dave Lyons
0176 0BC9              *
0177 0BC9              * When shutting down the Menu Manager, now I check flag bit 2 to
0178 0BC9              * ShutDownTools; if the bit is clear, I wipe out the menu bar
0179 0BC9              * rectangle before MenuShutDown.
0180 0BC9              *
0181 0BC9              * Renamed ShutDownTools flag bit 2 from leaveScreenOn to
0182 0BC9              * leaveScreenIntact.  We have a leaveScreenOn bit internally
0183 0BC9              * that we set if the QD user id matches the GetName user ID.
0184 0BC9              *
0185 0BC9              * LeaveScreenIntact means we don't wipe out the menu bar.
0186 0BC9              * (If it's invisible, we don't wipe it out.)
0187 0BC9              *
0188 0BC9              * 25-Feb-91         Dave Lyons
0189 0BC9              *
0190 0BC9              * If we're starting both QD and EM, the ShowCursor now happens
0191 0BC9              * after EMStartUp instead of after QDStartUp.  This way we don't
0192 0BC9              * see the cursor at the top left of the screen if EMStartUp is
0193 0BC9              * going to put it someplace else.
0194 0BC9              *
0195 0BC9              * StartUpTools: flags bit 4 ($0010) avoids starting the Resource
0196 0BC9              * Manager and pre-allocating the super-hires memory.  Intended for
0197 0BC9              * use when it's not your first StartUpTools call, or QD is already
0198 0BC9              * on, or you don't want to start the Resource Manager.
0199 0BC9              *
0200 0BC9              * ShutDownTools: flags bit 4 ($0010) avoids shutting down the
0201 0BC9              * Resource Manager.
0202 0BC9              *
0203 0BC9              * Including the Resource Manager in the tool record is now a no-op.
0204 0BC9              *
0205 0BC9              * 26-Feb-91         Dave Lyons
0206 0BC9              *
0207 0BC9              * Whoops, I apparently didn't actually try my previous changes.  Fixed
0208 0BC9              * it so it builds now.
0209 0BC9              *
0210 0BC9              * 28-Feb-91         Dave Lyons
0211 0BC9              *
0212 0BC9              * Changed value of leaveScreenOn (used internally only) so it doesn't
0213 0BC9              * conflict with any external flag bits.
0214 0BC9              *
0215 0BC9              * 21-Apr-91         Dave Lyons
0216 0BC9              *
0217 0BC9              * Made ShutDownTools call InitCursor.
0218 0BC9              *
0219 0BC9              * 30-Apr-91         Dave Lyons
0220 0BC9              *
0221 0BC9              * Made ShutDownTools call HideCursor instead of InitCursor.
0222 0BC9              *
0223 0BC9              * 15-Sep-91         Dave Lyons
0224 0BC9              *
0225 0BC9              * ShutDownTools no longer hides the cursor if flag bit 4 is
0226 0BC9              * set ("partial shutdown", skip resource manager stuff, etc).
0227 0BC9              *
0228 0BC9              * 19-Sep-91         Dave Lyons
0229 0BC9              *
0230 0BC9              * ShutDownTools resets the ShowBootInfo location for drawing icons.
0231 0BC9              *
0232 0BC9              * 25-Oct-91         Dave Lyons
0233 0BC9              *
0234 0BC9              * Moved a TAX in BuildLoadTable so StartUpTools will work okay for
0235 0BC9              * tools that are bigger than we recognized (will use no parameters
0236 0BC9              * when calling StartUp function).
0237 0BC9              *
0238 0BC9              * 17-Dec-91         Dave Lyons
0239 0BC9              *
0240 0BC9              * In BuildToolTable, added code to call ReportIfMissing, so that
0241 0BC9              * missing tools show a "This application needs ToolXXX" dialog.
0242 0BC9              *
0243 0BC9              **********************************************************************
0244 0BC9              *
0245 0BC9              * 17-Mar-92         Dave Lyons for 6.0.1
0246 0BC9              *
0247 0BC9              * Shutting down Standard File now tolerates errors (in case some
0248 0BC9              * NDA stupidly shut it down during DeskShutDown).
0249 0BC9              *
0250 0BC9              * 2-Apr-92          Dave Lyons
0251 0BC9              *
0252 0BC9              * ShutDownTools no longer calls HideCursor if QD is inactive.
0253 0BC9              *
0254 0BC9              * 1-Jul-92          Dave Lyons
0255 0BC9              *
0256 0BC9              * StartUpTools now returns any error from ResourceStartUp.  When
0257 0BC9              * we would have returned garbage for the result, we return NIL.
0258 0BC9              *
0259 0BC9              * ShutDownTools:  We check for a NIL input and behave sanely.
0260 0BC9              * ResourceShutDown is now in the error-exit path, so it shuts
0261 0BC9              * down the RM even if you get some other error.
0262 0BC9              *
0263 0BC9              **********************************************************************
0264 0BC9
0265 0BC9                       Blanks off                     ;No white space in the operand field.
0266 0BC9
0267 0BC9                       INCLUDE 'all.macros' 
0268 0BC9                       include 'e16.memory' 
0269 0BC9
0270 0BC9
0271 0BC9              **********************************************************************
0272 0BC9              *
0273 0BC9              *   Startup - Shutdown tool equates.
0274 0BC9              *
0275 0BC9              **********************************************************************
0276 0BC9
0277 0BC9
0278 0BC9              StartStopRecord Record 0 
0279 0BC9              Flags    ds.w 1 Flags for starting and stopping
0280 0BC9              VideoMode ds.w 1 SCB byte of mode to startup in.
0281 0BC9              ResFileID ds.w 1  Return file ID of app's res file, NIL = none.
0282 0BC9              DPageHandle ds.L 1 holds handle allocated for dpage
0283 0BC9
0284 0BC9              NumTools ds.w 1   Number of tools to load.
0285 0BC9              ToolArray ds.w 2 Array of tools to load, elements defined as:
0286 0BC9              ;                                            WORD - tool number.
0287 0BC9              ;                                            WORD - minimum version number.
0288 0BC9
0289 0BC9                       ENDR 
0290 0BC9
0291 0BC9              ;
0292 0BC9              ; --- Direct page offsets.
0293 0BC9              ;
0294 0BC9              loading  equ   1                        TRUE if loading tools.
0295 0BC9              loadTable equ   loading+2               Load tool hash table, enough for 48 tools.
0296 0BC9              directPages equ   loadTable+6
0297 0BC9              numPages equ   directPages+4
0298 0BC9              getNameBlk equ   numPages+2
0299 0BC9              getName  equ   getNameBlk+2
0300 0BC9              getUserID equ   getName+4
0301 0BC9              handle   equ   getUserID+2              ;added 2nd parameter to GetName, 17-Feb-91 DAL
0302 0BC9              ptr      equ   handle+4
0303 0BC9              UtilFlags equ   ptr+4
0304 0BC9              saveDbank equ   UtilFlags+4             Flags for use with sound tool startup (used Bits 0-3)
0305 0BC9              saveDpage equ   saveDbank+1
0306 0BC9              retAddr  equ   saveDpage+2
0307 0BC9              startRec equ   retAddr+6
0308 0BC9              startRecFlag equ   startRec+4
0309 0BC9              userID   equ   startRecFlag+2
0310 0BC9              result   equ   userID+2
0311 0BC9
0312 0BC9              leaveScreenIntact equ   4               ;bit 2 for ShutDownTools startRecFlag (DAL)
0313 0BC9              openResReadWrite equ   8                ;(MUST BE BIT 3!) for StartUpTools: open resource fork read/write
0314 0BC9              skipResMgr equ   $10                    ;bit 4 for StartUpTools/ShutDownTools: skip RM & pre-allocation
0315 0BC9              leaveScreenOn equ   $20                 ;bit 5 for ShutDownTools startRecFlag (used internally ONLY!)
0316 0BC9
0317 0BC9              ;
0318 0BC9              ; --- Tool error codes.
0319 0BC9              ;
0320 0BC9              TLBadRecFlag equ   $0103                Invalid startup record flag passed.
0321 0BC9              TLCantLoad equ   $0104                  Cant load a tool.
0322 0BC9              ;
0323 0BC9              ;
0324 0BC9              ; --- Tool startup resource equates.
0325 0BC9              ;
0326 0BC9              rToolStartup equ   $8013                Resource type of tool startup record.
0327 0BC9              ;
0328 0BC9              ;
0329 0BC9              ; --- UtilFlags codes.
0330 0BC9              WantsSound equ   $0001                  indicates sound tools desired
0331 0BC9              WantsSynth equ   $0002                  indicates Note Synth desired
0332 0BC9              WantsSeq equ   $0004                    indicates wants note seuqencer started
0333 0BC9              WantsMIDI equ   $0008                   indicates wants MIDI started
0334 0BC9              ;
0335 0BC9              ; --- Tool set numbers used
0336 0BC9              ;
0337 0BC9              SoundToolSet equ   8
0338 0BC9              NoteSynth equ   25
0339 0BC9              NoteSeq  equ   26
0340 0BC9              MIDITools equ   32
0341 0BC9              ; --- System equates.
0342 0BC9              ;
0343 0BC9              IncBusyFlg equ   $E10064
0344 0BC9              DecBusyFlg equ   $E10068
0345 0BC9
0346 0BC9              Stack_Entry equ   $E100B0
0347 0BC9
0348 0BC9
0349 0BC9              ****************************************************************
0350 0BC9              *
0351 0BC9              StartupTools PROC EXPORT 
0352 0BC9              *
0353 0BC9              * Description
0354 0BC9              *
0355 0BC9              *
0356 0BC9              *   IN: 
0357 0BC9              *     PUSH:LONG - space for result.
0358 0BC9              *     PUSH:WORD - User ID.
0359 0BC9              *     PUSH:WORD - 0 if startup record is a pointer, 4 if a resource ID.
0360 0BC9              *     PUSH:LONG - pointer or resource ID of startup record.
0361 0BC9              *
0362 0BC9              *  OUT: 
0363 0BC9              *     PULL:LONG - handle of startup record if a resource ID was passed, 
0364 0BC9              *                   else pointer to record.
0365 0BC9              *
0366 0BC9              * External Refs:
0367 0BC9                       IMPORT startCall 
0368 0BC9                       IMPORT openAppRes 
0369 0BC9                       IMPORT getStartupPtr 
0370 0BC9                       IMPORT walkToolArray 
0371 0BC9                       IMPORT pop 
0372 0BC9                       import KillIt 
0373 0BC9              *
0374 0BC9              * Entry Points:
0375 0BC9              *                   none
0376 0BC9              *
0377 0BC9                       longa on                       ; mode
0378 0BC9                       longi on
0379 0BC9              *
0380 0BC9              ****************************************************************
0381 0BC9
0382 0BC9 20 0B 15              jsr   startCall                Allocate a direct page.
0383 0BCC
0384 0BCC              *** added 1-Jul-92 DAL -- Pre-zero the result field so we do not return garbage
0385 0BCC 64 34                 stz   <result
0386 0BCE 64 36                 stz   <result+2
0387 0BD0              *** end 1-Jul-92
0388 0BD0
0389 0BD0              ;
0390 0BD0              ; Set the global system preferences so that under certain circumstances the
0391 0BD0              ; system's Mount facility will be called asking the user to mount a specified volume
0392 0BD0              ;
0393 0BD0
0394 0BD0              ; First save the current System Preferences
0395 0BD0
0396 0BD0 F4 00 00              pea   0                        Set up paramBlock for call
0397 0BD3 F4 01 00              pea   1
0398 0BD6 3B                    tsc                            calculate address to paramblock
0399 0BD7 1A                    inc   a                        and push on stack
0400 0BD8 F4 00 00              pea   0
0401 0BDB 48                    pha   
0402 0BDC F4 0F 20              pea   $200F                    Get_Sys_Prefs
0403 0BDF 22 B0 00 E1           jsl   Stack_Entry              Leave parameter block on the stack so we can restore later
0404 0BE3
0405 0BE3              ; Now set the System preferences to display volume mount dialog w/o the cancel button
0406 0BE3
0407 0BE3 F4 00 C0              pea   $C000                    system preferences
0408 0BE6 F4 01 00              pea   1                        pcount
0409 0BE9 3B                    tsc                            calculate address to paramblock
0410 0BEA 1A                    inc   a                        and push on stack
0411 0BEB F4 00 00              pea   0
0412 0BEE 48                    pha   
0413 0BEF F4 0C 20              pea   $200C                    Set_Sys_Prefs
0414 0BF2 22 B0 00 E1           jsl   Stack_Entry
0415 0BF6 68                    pla                            Get Parameter block off the stack.
0416 0BF7 68                    pla   
0417 0BF8              ;
0418 0BF8              ;
0419 0BF8              ; --- Open application's resource file.
0420 0BF8              ;
0421 0BF8 20 38 15              jsr   openAppRes               Open application's resource file.
0422 0BFB              *** added 1-Jul-92 DAL -- check for bad error
0423 0BFB B0 07                 bcs   @toErrOut                ;Y = error if SEC
0424 0BFD              *** end 1-Jul-92
0425 0BFD
0426 0BFD 48                    pha                            Save open resource file ID.
0427 0BFE 20 B5 14              jsr   getStartupPtr            Get startup record pointer.
0428 0C01 68                    pla   
0429 0C02 90 03                 bcc   @ok1                     Error?  Y = error code.
0430 0C04 82 CB 00     @toErrOut brl   @errOut
0431 0C07
0432 0C07 A0 04 00     @ok1     ldy   #StartStopRecord.ResFileID Return file ID of app's open resource file.
0433 0C0A 97 2C                 sta   [<startRec],y
0434 0C0C              ;
0435 0C0C              ;
0436 0C0C              ; --- Allocate direct pages for tools.
0437 0C0C              ;
0438 0C0C 64 0D                 stz   <numPages                Start with no pages.
0439 0C0E 64 1F                 stz   <UtilFlags               zero out the flags
0440 0C10              ;
0441 0C10 A9 36 12              lda   #addPages                Compute number of direct pages needed.
0442 0C13 20 E2 15              jsr   walkToolArray
0443 0C16              ;
0444 0C16 A5 0D                 lda   <numPages                Any direct pages needed?
0445 0C18 F0 2C                 beq   @skip1
0446 0C1A              ;
0447 0C1A A9 00 00              lda   #0                       Common need.
0448 0C1D 48                    pha                            Space for result.
0449 0C1E 48                    pha   
0450 0C1F 48                    pha                            Pass number of bytes to allocate.
0451 0C20 D4 0D                 pei   <numPages
0452 0C22 D4 32                 pei   <userID                  Pass my user ID.
0453 0C24 F4 05 C0              pea   $C005                    Pass attributes; locked, fixed bank, page aligned.
0454 0C27 48                    pha                            Pass address, bank zero.
0455 0C28 48                    pha   
0456 0C29 A2 02 09 22           _NewHandle 
0457 0C30 A8                    tay                            Possible error code.
0458 0C31 68                    pla   
0459 0C32 85 09                 sta   <directPages
0460 0C34 68                    pla   
0461 0C35 85 0B                 sta   <directPages+2
0462 0C37 B0 CB                 bcs   @toErrOut
0463 0C39
0464 0C39              ;-----------------------------------------------------------
0465 0C39              ;
0466 0C39              ; Put direct page handle into the startstop record.
0467 0C39              ;
0468 0C39
0469 0C39 A0 06 00              ldy   #StartStopRecord.DPageHandle
0470 0C3C A5 09                 lda   directPages
0471 0C3E 97 2C                 sta   [StartRec],y
0472 0C40 C8                    iny   
0473 0C41 C8                    iny   
0474 0C42 A5 0B                 lda   directPages+2
0475 0C44 97 2C                 sta   [StartRec],y
0476 0C46
0477 0C46
0478 0C46              ;
0479 0C46              ;
0480 0C46              ; --- Load and start tools requested by caller.
0481 0C46              ;
0482 0C46              @skip1    
0483 0C46 64 03                 stz   <loadTable               Clear tool load table.
0484 0C48 64 05                 stz   <loadTable+2
0485 0C4A 64 07                 stz   <loadTable+4
0486 0C4C              ;
0487 0C4C 64 01                 stz   <loading                 TRUE for loading tools.
0488 0C4E E6 01                 inc   <loading
0489 0C50              ;
0490 0C50
0491 0C50 A9 00 00              lda   #0
0492 0C53 48                    pha   
0493 0C54 48                    pha   
0494 0C55              *** added 25-Feb-91 DAL
0495 0C55 A5 30                 lda   <startRecFlag
0496 0C57 29 10 00              and   #skipResMgr
0497 0C5A D0 19                 bne   @skipPreallocate         ;if we skip, there is a NIL handle on the stack
0498 0C5C              *** end of 25-Feb-91 DAL
0499 0C5C F4 00 00 F4           PushLong #$00008000 
0500 0C62 F4 01 40              PushWord #$4001                ; tool locator's user id
0501 0C65 F4 02 00              PushWord #attrAddr 
0502 0C68 F4 E1 00 F4           PushLong #$00E12000 
0503 0C6E A2 02 09 22           _NewHandle 
0504 0C75              @skipPreallocate  
0505 0C75
0506 0C75 A9 B6 12              lda   #buildLoadTable          Build hash table of tools to load.
0507 0C78 20 E2 15              jsr   walkToolArray
0508 0C7B
0509 0C7B 68                    pla                            Get handle to screen into
0510 0C7C FA                    plx                            a & X
0511 0C7D
0512 0C7D 08                    php                            Save error status
0513 0C7E 5A                    phy                            Save error code
0514 0C7F
0515 0C7F 20 F4 18              jsr   KillIt
0516 0C82
0517 0C82 7A                    ply                            Restore error code and
0518 0C83 28                    plp                            status register
0519 0C84
0520 0C84 90 0D                 bcc   @ok2                     Error loading tools?
0521 0C86              ;
0522 0C86 98                    tya   
0523 0C87 48           @errOut2 pha                            Save error code.
0524 0C88 A6 0B                 ldx   <directPages+2           Free allocated direct pages.
0525 0C8A A5 09                 lda   <directPages
0526 0C8C 20 F4 18              jsr   KillIt
0527 0C8F 7A                    ply                            Restore error code.
0528 0C90 82 3F 00              brl   @errOut
0529 0C93              ;
0530 0C93 64 0D        @ok2     stz   <numPages                Start with first page.
0531 0C95              ;
0532 0C95              ; --- Startup loop.
0533 0C95              ;
0534 0C95 A2 00 00              ldx   #0
0535 0C98 80 15                 bra   @enter1
0536 0C9A DA           @lop1    phx   
0537 0C9B
0538 0C9B 20 07 13              jsr   checkLoadTable           Check if user wants this tool started.
0539 0C9E F0 0B                 beq   @next1
0540 0CA0
0541 0CA0 A3 01                 lda   1,s                       Call startup handler.
0542 0CA2 AA                    tax   
0543 0CA3 FC E8 11              jsr   (@startupTable+1,x)
0544 0CA6 90 03                 bcc   @next1                   No error?
0545 0CA8 FA                    plx                            Error, so clean up stack and beat it.
0546 0CA9 80 DC                 bra   @errOut2
0547 0CAB
0548 0CAB FA           @next1   plx                            Next tool.
0549 0CAC E8                    inx   
0550 0CAD E8                    inx   
0551 0CAE E8                    inx   
0552 0CAF BD E7 11     @enter1  lda   |@startupTable,x         Next tool to start.
0553 0CB2 29 FF 00              and   #$00FF
0554 0CB5 D0 E3                 bne   @lop1                    Any more tools?
0555 0CB7
0556 0CB7
0557 0CB7
0558 0CB7              ;-----------------------------------------------------------
0559 0CB7              ;
0560 0CB7              ; Return the result to the calling routine.
0561 0CB7              ;
0562 0CB7 A5 17                 lda   handle
0563 0CB9 85 34                 sta   Result
0564 0CBB A5 19                 lda   handle+2
0565 0CBD 85 36                 sta   Result+2
0566 0CBF
0567 0CBF              ;-----------------------------------------------------------
0568 0CBF              ;
0569 0CBF              ; Unlock if input was handle or resource
0570 0CBF              ;
0571 0CBF              ;
0572 0CBF A5 30                 lda   StartRecFlag
0573 0CC1 29 03 00              and   #3                       ;bits 0-1 (added 17-Nov-90 DAL)
0574 0CC4 F0 09                 beq   @IsPtr
0575 0CC6 A0 04 00              ldy   #4
0576 0CC9 B7 17                 lda   [<handle],y
0577 0CCB              ;        and   #$7FFF
0578 0CCB 0A                    asl   a
0579 0CCC 4A                    lsr   a
0580 0CCD 97 17                 sta   [<handle],y
0581 0CCF              @IsPtr    
0582 0CCF
0583 0CCF A0 00 00              ldy   #0                       No error.
0584 0CD2
0585 0CD2 3B           @errOut  tsc                            Parameter block for Set_Sys_Prefs still on stack
0586 0CD3 1A                    inc   a
0587 0CD4 F4 00 00              pea   0000
0588 0CD7 48                    pha   
0589 0CD8 F4 0C 20              pea   $200C
0590 0CDB 22 B0 00 E1           jsl   Stack_Entry
0591 0CDF FA                    plx                            Get parameter block off the stack.
0592 0CE0 FA                    plx   
0593 0CE1              ;
0594 0CE1              ; --- Exit.
0595 0CE1              ;
0596 0CE1              ;  y = error code.
0597 0CE1              ;
0598 0CE1 A2 08 00              ldx   #8                       Number of bytes to strip.
0599 0CE4 82 54 02              brl   pop
0600 0CE7
0601 0CE7
0602 0CE7              **********************************************************************
0603 0CE7              *
0604 0CE7              * This is the startup table.  To add a tool to be started up add
0605 0CE7              * a record to this table at the position you want it to be started.
0606 0CE7              * The first tool started is the first tool in the table.
0607 0CE7              * A record is a one byte tool number followed by a one word
0608 0CE7              * address of a routine that starts the tool.  The routine should 
0609 0CE7              * start the tool and return carry set if there is an error with
0610 0CE7              * an error code in a.
0611 0CE7              *
0612 0CE7              **********************************************************************
0613 0CE7                       IMPORT startMiscTools 
0614 0CE7                       IMPORT startQuickDraw 
0615 0CE7                       IMPORT startQDAux 
0616 0CE7                       IMPORT startEventMgr 
0617 0CE7                       IMPORT startWindowMgr 
0618 0CE7                       IMPORT startControlMgr 
0619 0CE7                       IMPORT startMenuMgr 
0620 0CE7                       IMPORT startDialog 
0621 0CE7                       IMPORT startLineEdit 
0622 0CE7                       IMPORT startStandardFile 
0623 0CE7                       IMPORT startDeskMgr 
0624 0CE7                       IMPORT startScrap 
0625 0CE7                       IMPORT startSound 
0626 0CE7                       IMPORT startSANE 
0627 0CE7                       IMPORT startPrintMgr 
0628 0CE7                       IMPORT startFont 
0629 0CE7                       IMPORT startTextEdit 
0630 0CE7                       IMPORT startNoteSynth 
0631 0CE7                       IMPORT StartNoteSeq 
0632 0CE7                       IMPORT startMIDI 
0633 0CE7                       IMPORT startACE 
0634 0CE7                       import startPokey 
0635 0CE7                       import startAnimation          ;added 17-Nov-90 DAL
0636 0CE7                       import startMediaCtl           ;added 17-Nov-90 DAL
0637 0CE7                       import startMidiSynth          ;added 17-Nov-90 DAL
0638 0CE7                       import startResMgr             ;26-Feb-91 DAL
0639 0CE7
0640 0CE7 03           @startupTable DC B:3
0641 0CE8 1E 16                 DC W:startMiscTools
0642 0CEA 04                    DC B:4
0643 0CEB 26 16                 DC W:startQuickDraw
0644 0CED 12                    DC B:18
0645 0CEE 5E 16                 DC W:startQDAux
0646 0CF0 06                    DC B:6
0647 0CF1 6D 16                 DC W:startEventMgr
0648 0CF3 0E                    DC B:14
0649 0CF4 AC 16                 DC W:startWindowMgr
0650 0CF6 10                    DC B:16
0651 0CF7 CE 16                 DC W:startControlMgr
0652 0CF9 0F                    DC B:15
0653 0CFA DE 16                 DC W:startMenuMgr
0654 0CFC 14                    DC B:20
0655 0CFD 07 17                 DC W:startLineEdit
0656 0CFF 15                    DC B:21
0657 0D00 FD 16                 DC W:startDialog
0658 0D02 16                    DC B:22
0659 0D03 31 17                 DC W:startScrap
0660 0D05 17                    DC B:23
0661 0D06 17 17                 DC W:startStandardFile
0662 0D08 1B                    DC B:27
0663 0D09 AB 18                 DC W:startFont
0664 0D0B 13                    DC B:19
0665 0D0C 9B 18                 DC W:startPrintMgr
0666 0D0E 22                    DC B:34
0667 0D0F BB 18                 DC W:startTextEdit
0668 0D11 08                    DC B:8
0669 0D12 39 17                 DC W:startSound
0670 0D14 19                    DC B:NoteSynth
0671 0D15 4E 17                 DC W:startNoteSynth
0672 0D17 1A                    DC B:NoteSeq
0673 0D18 4F 18                 DC W:StartNoteSeq
0674 0D1A 20                    DC B:MIDITools
0675 0D1B 3F 18                 DC W:StartMIDI
0676 0D1D 1D                    DC B:29
0677 0D1E 77 18                 DC W:startACE
0678 0D20 0A                    DC B:10
0679 0D21 85 18                 DC W:startSANE
0680 0D23 21                    DC B:33
0681 0D24 93 18                 DC W:startPokey
0682 0D26 23                    DC B:35                        ;added 17-Nov-90 DAL
0683 0D27 CB 18                 DC W:startMidiSynth            ;added 17-Nov-90 DAL
0684 0D29 25                    DC B:37                        ;added 17-Nov-90 DAL
0685 0D2A D3 18                 DC W:startAnimation            ;added 17-Nov-90 DAL
0686 0D2C 26                    DC B:38                        ;added 17-Nov-90 DAL
0687 0D2D EA 18                 DC W:startMediaCtl             ;added 17-Nov-90 DAL
0688 0D2F 05                    DC B:5
0689 0D30 27 17                 DC W:startDeskMgr
0690 0D32 1E                    DC B:$1E                       ;added 25-Feb-91 DAL
0691 0D33 2F 17                 DC W:startResMgr               ;added 25-Feb-91 DAL (no-op)
0692 0D35 00                    DC B:0                         ;No more tools.
0693 0D36
0694 0D36
0695 0D36              ;-----------------------------------------------------
0696 0D36              ;   Compute number of direct pages needed.
0697 0D36              ;-----------------------------------------------------
0698 0D36              ;
0699 0D36              ;   IN: y = index to tool in startup record.
0700 0D36              ;   a = tool number.
0701 0D36              ;   <numPages = current number of direct pages needed.
0702 0D36              ;
0703 0D36 C9 27 00     addPages cmp   #endTools-toolTable      Tool number in range?
0704 0D39 B0 46                 bcs   @exit
0705 0D3B A8                    tay                            place the tool number in <Y>
0706 0D3C              ;
0707 0D3C              ; First test to see if this is one of the sound tools
0708 0D3C A2 00 00              ldx   #0                       use <X> as a temp flag
0709 0D3F C9 08 00              cmp   #SoundToolSet            is this the sound tools?
0710 0D42 D0 05                 bne   @AP0010                  if not test for note synth
0711 0D44 A9 01 00              lda   #WantsSound              load the proper flag
0712 0D47 80 1E                 bra   @SetFlag                 and set it
0713 0D49
0714 0D49 C9 19 00     @AP0010  cmp   #NoteSynth               is it the Note synthesizer?
0715 0D4C D0 05                 bne   @AP0020                  if not test for MIDI
0716 0D4E A9 02 00              lda   #WantsSynth              load the proper flag
0717 0D51 80 14                 bra   @SetFlag                 and set it
0718 0D53
0719 0D53 C9 20 00     @AP0020  cmp   #MIDITools               is it the MIDI Tools?
0720 0D56 D0 06                 bne   @AP0030                  if not test for Note Sequencer
0721 0D58 A9 08 00              lda   #WantsMIDI
0722 0D5B AA                    tax                            set <X> flag to be true
0723 0D5C 80 09                 bra   @SetFlag
0724 0D5E
0725 0D5E C9 1A 00     @AP0030  cmp   #NoteSeq                 is it the note sequencer?
0726 0D61 D0 12                 bne   @DoAdd                   if not, just add in the proper value
0727 0D63 A9 04 00              lda   #WantsSeq                load the proper flag
0728 0D66 AA                    tax                            and set our <X>flag to be true
0729 0D67
0730 0D67              ; The SetFlag routine sets the proper flag in the UtilFlags word for the tool
0731 0D67              ; and then checks to see if the Note sequencer has already been added, If so, 
0732 0D67              ; we will skip adding more direct page space for the tools.
0733 0D67 05 1F        @SetFlag ora   <UtilFlags               set the flag
0734 0D69 85 1F                 sta   <UtilFlags
0735 0D6B E0 00 00              cpx   #00                      test <X> for zero
0736 0D6E D0 13                 bne   @AddSeq                  if its non-zero we are adding the sequencer or MIDI
0737 0D70 29 04 00              and   #WantsSeq                next test if they already added sequencer direct page
0738 0D73 D0 0C                 bne   @Exit                    if so, then we no longer need to add direct page
0739 0D75
0740 0D75              ; Now add the standard direct page value
0741 0D75 B9 8F 12     @DoAdd   lda   |toolTable,y             Get pages this tool needs.
0742 0D78 29 7F 00              and   #$007F
0743 0D7B EB                    xba   
0744 0D7C 18                    clc   
0745 0D7D 65 0D                 adc   <numPages                Increment total pages needed.
0746 0D7F 85 0D                 sta   <numPages
0747 0D81              ;
0748 0D81 18           @exit    clc                            Continue flag.
0749 0D82 60                    rts   
0750 0D83              ; Add the sequencer direct page, but first test to see if the other tools have
0751 0D83              ; already been added.
0752 0D83 A5 1F        @AddSeq  lda   <UtilFlags               get the flags
0753 0D85 AA                    tax                            save it for later
0754 0D86 29 01 00              and   #WantsSound              test to see if sound already added in
0755 0D89 D0 02                 bne   @AS0010                  if not the test for MIDI
0756 0D8B C6 0C                 dec   <numPages-1              decrement the number of pages by 1
0757 0D8D 80 E6        @AS0010  bra   @DoAdd                   if not, go ahead and add the proper number of pages
0758 0D8F
0759 0D8F              canLoad  equ   $0080                    TRUE if I can load this tool.
0760 0D8F
0761 0D8F                       ENTRY toolTable 
0762 0D8F 00           toolTable DC B:0                        0 - not used.
0763 0D90 80                    DC B:canLoad+0                 1 - Tool Locator, startup not needed.
0764 0D91 80                    DC B:canLoad+0                 2 - Memory Manager, started by application.
0765 0D92 80                    DC B:canLoad+0                 3 - Misc. Tool set.
0766 0D93 83                    DC B:canLoad+3                 4 - QuickDraw II.
0767 0D94 80                    DC B:canLoad+0                 5 - Desk Manager.
0768 0D95 81                    DC B:canLoad+1                 6 - Event Manger.
0769 0D96 80                    DC B:canLoad+0                 7 - Scheduler, startup not needed.
0770 0D97 81                    DC B:canLoad+1                 8 - Sound tool set.
0771 0D98 80                    DC B:canLoad+0                 9 - Apple Desktop Bus Tool set, startup not needed.
0772 0D99 81                    DC B:canLoad+1                 10 - SANE
0773 0D9A 80                    DC B:canLoad+0                 11 - Integer Math tool set, startup not needed.
0774 0D9B 80                    DC B:canLoad+0                 12 - Text tool set, startup not needed.
0775 0D9C 00                    DC B:0                         13 - not used.
0776 0D9D 80                    DC B:canLoad+0                 14 - Window Manager.
0777 0D9E 81                    DC B:canLoad+1                 15 - Menu Manager.
0778 0D9F 81                    DC B:canLoad+1                 16 - Control Manager.
0779 0DA0 80                    DC B:canLoad+0                 17 - System Loader, startup not needed.
0780 0DA1 80                    DC B:canLoad+0                 18 - QuickDraw Auxiliary.
0781 0DA2 82                    DC B:canLoad+2                 19 - Print Manager.
0782 0DA3 81                    DC B:canLoad+1                 20 - LineEdit
0783 0DA4 80                    DC B:canLoad+0                 21 - Dialog Manager.
0784 0DA5 80                    DC B:canLoad+0                 22 - Scrap Manager.
0785 0DA6 81                    DC B:canLoad+1                 23 - Standard File Operations.
0786 0DA7 80                    DC B:canLoad+0                 24 - future Tool.
0787 0DA8 80                    DC B:canLoad+0                 25 - Note synthesizer.
0788 0DA9 83                    DC B:canLoad+3                 26 - Note sequencer.
0789 0DAA 81                    DC B:canLoad+1                 27 - Font Manager.
0790 0DAB 80                    DC B:canLoad+0                 28 - List Manager, startup not needed.
0791 0DAC 81                    DC B:canLoad+1                 29 - ACE
0792 0DAD 80                    DC B:canLoad+0                 30 - Resource Manager, startup always happens.
0793 0DAE 80                    DC B:canLoad+0                 31 - not used.
0794 0DAF 83                    DC B:canLoad+3                 32 - MIDI
0795 0DB0 80                    DC B:canLoad+0                 33 - Pokey
0796 0DB1 81                    DC B:canLoad+1                 34 - Text edit.
0797 0DB2 80                    DC B:canLoad+0                 35 - MidiSynth      (added 17-Nov-90 DAL)
0798 0DB3 00                    DC B:0                         36 - not used       (added 17-Nov-90 DAL)
0799 0DB4 81                    DC B:canLoad+1                 37 - Animation      (added 17-Nov-90 DAL)
0800 0DB5 80                    DC B:canLoad+0                 38 - Media Control  (added 17-Nov-90 DAL)
0801 0DB6              endTools  
0802 0DB6
0803 0DB6
0804 0DB6
0805 0DB6              **********************************************************************
0806 0DB6              *
0807 0DB6              *   Load tool.
0808 0DB6              *
0809 0DB6              *
0810 0DB6              *   IN: 
0811 0DB6              *        y          = index to tool in startup record.
0812 0DB6              *        a          = tool number.
0813 0DB6              *        <numPages  = next available direct page.
0814 0DB6              *        <loading   = TRUE to load tools.
0815 0DB6              *
0816 0DB6              *  OUT:  Carry set if error, y = error code.
0817 0DB6              *
0818 0DB6              **********************************************************************
0819 0DB6                       import ReportIfMissing 
0820 0DB6
0821 0DB6                       entry buildLoadTable 
0822 0DB6              buildLoadTable  
0823 0DB6 AA                    tax                            ;25-Oct-91 DAL
0824 0DB7 C9 27 00              cmp   #endTools-toolTable      Tool number in range?
0825 0DBA B0 08                 bcs   @OkToTry
0826 0DBC
0827 0DBC              ;;;      tax                            ;moved above 25-Oct-91 DAL
0828 0DBC BD 8F 12              lda   |toolTable,x             ;Is there a loader for the tool?
0829 0DBF 29 FF 00              and   #$00FF
0830 0DC2 F0 36                 beq   @cantError
0831 0DC4
0832 0DC4              @OkToTry  
0833 0DC4              ;
0834 0DC4 A5 01                 lda   <loading                 Am I loading tools?
0835 0DC6 F0 1B                 beq   @skip1
0836 0DC8              ;
0837 0DC8 DA                    phx                            Save tool number.
0838 0DC9              ;
0839 0DC9 DA                    phx                            Pass tool number.
0840 0DCA C8                    iny   
0841 0DCB C8                    iny   
0842 0DCC B7 2C                 lda   [<startRec],y            Pass minimum tool version.
0843 0DCE 48                    pha   
0844 0DCF A2 01 0F 22           _LoadOneTool 
0845 0DD6 A8                    tay                            Possible error code.
0846 0DD7 FA                    plx                            Restore tool number.
0847 0DD8 90 09                 bcc   @skip1
0848 0DDA              *** added 17-Dec-91 DAL -- put up an alert saying they need the tool
0849 0DDA 5A                    phy   
0850 0DDB 8A                    txa                            ;tool # in A
0851 0DDC BB                    tyx                            ;error in X for ReportIfMissing
0852 0DDD 20 62 19              jsr   ReportIfMissing
0853 0DE0 7A                    ply                            ;error code
0854 0DE1 38                    sec   
0855 0DE2              *** end 17-Dec-91
0856 0DE2 60                    rts                            Abort.
0857 0DE3
0858 0DE3 8A           @skip1   txa                            Compute index to bit in LoadTable.
0859 0DE4 29 07 00              and   #$0007
0860 0DE7 A8                    tay   
0861 0DE8              ;
0862 0DE8 8A                    txa   
0863 0DE9 4A                    lsr   a
0864 0DEA 4A                    lsr   a
0865 0DEB 4A                    lsr   a
0866 0DEC AA                    tax   
0867 0DED              ;
0868 0DED E2 20                 sep   #$20                     Set bit in hash table for tool to be loaded.
0869 0DEF                       LONGA OFF
0870 0DEF B5 03                 lda   <loadTable,x
0871 0DF1 19 FF 12              ora   |loadMasks,y
0872 0DF4 95 03                 sta   <loadTable,x
0873 0DF6 C2 20                 rep   #$20
0874 0DF8                       LONGA ON
0875 0DF8              ;
0876 0DF8 18                    clc                            Continue flag.
0877 0DF9 60                    rts   
0878 0DFA              ;
0879 0DFA A0 04 01     @cantError ldy   #TLCantLoad            Error code.
0880 0DFD 38                    sec   
0881 0DFE 60                    rts   
0882 0DFF              ;
0883 0DFF 80 40 20 10  loadMasks DC B:$80,$40,$20,$10,$08,$04,$02,$01
0884 0E07
0885 0E07
0886 0E07              **********************************************************************
0887 0E07              *
0888 0E07              *   Check loadTable if tool should be loaded.
0889 0E07              *
0890 0E07              *
0891 0E07              *   IN: a           = tool number, already checked for being in range.
0892 0E07              *       <loadTable  = pointer to load table.
0893 0E07              *
0894 0E07              **********************************************************************
0895 0E07
0896 0E07                       entry checkLoadTable 
0897 0E07 48           checkLoadTable pha   
0898 0E08 29 07 00              and   #$0007
0899 0E0B A8                    tay   
0900 0E0C
0901 0E0C 68                    pla   
0902 0E0D 4A                    lsr   a
0903 0E0E 4A                    lsr   a
0904 0E0F 4A                    lsr   a
0905 0E10 AA                    tax   
0906 0E11
0907 0E11 E2 20                 sep   #$20
0908 0E13                       LONGA OFF
0909 0E13 B5 03                 lda   <loadTable,x
0910 0E15 39 FF 12              and   |loadMasks,y
0911 0E18 C2 20                 rep   #$20
0912 0E1A                       LONGA ON
0913 0E1A 60                    rts   
0914 0E1B                       ENDP 
0915 0E1B
0916 0E1B
0917 0E1B
0918 0E1B              ****************************************************************
0919 0E1B              *
0920 0E1B              ShutdownTools PROC EXPORT 
0921 0E1B              *
0922 0E1B              *   If handle of startup record is passed the handle is disposed of.
0923 0E1B              *
0924 0E1B              *
0925 0E1B              *   IN: 
0926 0E1B              *     PUSH:WORD - 0 if startup record is a pointer, 2 if a handle.
0927 0E1B              *     PUSH:LONG - pointer or handle of startup record.
0928 0E1B              *
0929 0E1B              *  OUT: 
0930 0E1B              *     Nothing.
0931 0E1B              *
0932 0E1B              * Outputs:
0933 0E1B              *                   none
0934 0E1B              *
0935 0E1B              * External Refs:
0936 0E1B                       IMPORT startCall 
0937 0E1B                       IMPORT getStartupPtr 
0938 0E1B                       IMPORT checkLoadTable 
0939 0E1B                       IMPORT walkToolArray 
0940 0E1B                       import KillIt 
0941 0E1B                       IMPORT StopNoteSynth 
0942 0E1B                       IMPORT StopSound 
0943 0E1B                       import StopMM 
0944 0E1B                       import stopQuickDraw 
0945 0E1B                       import stopMenuMgr 
0946 0E1B                       import stopResMgr              ;26-Feb-91 DAL
0947 0E1B                       import stopStdFile             ;17-Mar-92 DAL
0948 0E1B
0949 0E1B              *
0950 0E1B              *
0951 0E1B              * Entry Points:
0952 0E1B              *                   none
0953 0E1B              *
0954 0E1B                       longa on                       ; mode
0955 0E1B                       longi on
0956 0E1B              *
0957 0E1B              ****************************************************************
0958 0E1B
0959 0E1B 20 0B 15              jsr   startCall                ;Allocate a direct page.
0960 0E1E
0961 0E1E              *** added 1-Jul-92 DAL -- If tool table reference is NIL, use a clean by-pointer table
0962 0E1E A5 2E                 lda   <startRec+2
0963 0E20 05 2C                 ora   <startRec
0964 0E22 D0 21                 bne   @notNIL
0965 0E24 A9 02 00              lda   #@defaultStopRecord>>16
0966 0E27 A2 39 13              ldx   #@defaultStopRecord
0967 0E2A 85 2E                 sta   <startRec+2
0968 0E2C 86 2C                 stx   <startRec
0969 0E2E 64 17                 stz   <handle
0970 0E30 64 19                 stz   <handle+2
0971 0E32 A9 03 00              lda   #3
0972 0E35 14 30                 trb   <startRecFlag            ;force it to be a pointer
0973 0E37 80 14                 bra   @ok1
0974 0E39
0975 0E39              @defaultStopRecord  
0976 0E39 00 00                 DC W:0                         ;flags
0977 0E3B 00 00                 DC W:0                         ;QD masterSCB
0978 0E3D 00 00                 DC W:0                         ;resFileID
0979 0E3F 00 00 00 00           DC L:0                         ;direct page handle
0980 0E43 00 00                 DC W:0                         ;tool count
0981 0E45
0982 0E45              @notNIL   
0983 0E45              *** end 1-Jul-92
0984 0E45 20 B5 14              jsr   getStartupPtr            ;Get startup record pointer.
0985 0E48 90 03                 bcc   @ok1                     ;Error?  Y = error code.
0986 0E4A 82 DB 00              brl   @errOut
0987 0E4D
0988 0E4D 64 03        @ok1     stz   <loadTable               ;Clear tool load table.
0989 0E4F 64 05                 stz   <loadTable+2
0990 0E51 64 07                 stz   <loadTable+4
0991 0E53
0992 0E53 F4 00 80              pea   $8000
0993 0E56 A9 00 00              lda   #0
0994 0E59 48                    pha                            ;StringPtr = $80000000
0995 0E5A 48                    pha   
0996 0E5B 48                    pha                            ;IconPtr = nil
0997 0E5C A2 03 3C 22           _ShowBootInfo                  ;initialize ShowBootInfo!
0998 0E63
0999 0E63 A5 30                 lda   <startRecFlag            ;added 15-Sep-91 DAL
1000 0E65 29 10 00              and   #skipResMgr              ;
1001 0E68 D0 12                 bne   @skipHide                ;(fixes bug 1009954)
1002 0E6A
1003 0E6A              *** added 2-Apr-92 DAL -- Don't call HideCursor if QD is not started (6.0.1)
1004 0E6A 48                    pha   
1005 0E6B A2 04 06 22           _QDStatus 
1006 0E72 68                    pla   
1007 0E73 F0 07                 beq   @skipHide
1008 0E75              *** end 2-Apr-92
1009 0E75 A2 04 90 22           _HideCursor 
1010 0E7C
1011 0E7C              @skipHide  
1012 0E7C
1013 0E7C              *** Force the leaveScreenOn bit on in the flags if GetName says
1014 0E7C              *** the user ID matches ours.
1015 0E7C
1016 0E7C A9 02 00              lda   #2
1017 0E7F 85 0F                 sta   <getNameBlk              ;GetNameGS with 2 parameters
1018 0E81
1019 0E81 3B                    tsc                            ;built a 32-character filename result buffer on the stack
1020 0E82 38                    sec   
1021 0E83 E9 24 00              sbc   #36                      ;space for filename buffer
1022 0E86 1B                    tcs   
1023 0E87 1A                    inc   a
1024 0E88 85 11                 sta   <getName
1025 0E8A 64 13                 stz   <getName+2
1026 0E8C A9 24 00              lda   #36
1027 0E8F 83 01                 sta   1,s                      ;store buffer size in first word
1028 0E91
1029 0E91 F4 00 00              pea   0
1030 0E94 7B                    tdc   
1031 0E95 18                    clc   
1032 0E96 69 0F 00              adc   #getNameBlk
1033 0E99 48                    pha   
1034 0E9A F4 27 20              pea   $2027                    ;GetNameGS
1035 0E9D 22 B0 00 E1           jsl   $e100b0                  ;stack OS entry
1036 0EA1 B0 24                 bcs   @err
1037 0EA3
1038 0EA3 48                    pha   
1039 0EA4 48                    pha                            ;space for GetWAP result
1040 0EA5 F4 00 00              pea   0                        ;system tool
1041 0EA8 F4 04 00              pea   4                        ;QuickDraw II
1042 0EAB A2 01 0C 22           _GetWAP 
1043 0EB2 FA                    plx   
1044 0EB3 68                    pla   
1045 0EB4              *** added 17-Feb-92 DAL for 6.0.1d1 -- If QD isn't started, don't check bogus zpage value
1046 0EB4 8A                    txa   
1047 0EB5 F0 10                 beq   @differentID
1048 0EB7              *** end 17-Feb-92
1049 0EB7 BF 0A 00 00           lda   >$00000A,x               ;QuickDraw user ID
1050 0EBB 29 FF F0              and   #$f0ff                   ;master ID
1051 0EBE C5 15                 cmp   <getUserID
1052 0EC0 D0 05                 bne   @differentID
1053 0EC2
1054 0EC2 A9 20 00              lda   #leaveScreenOn
1055 0EC5 04 30                 tsb   <startRecFlag            ;force the bit on
1056 0EC7
1057 0EC7              @differentID  
1058 0EC7 3B           @err     tsc   
1059 0EC8 18                    clc   
1060 0EC9 69 24 00              adc   #36
1061 0ECC 1B                    tcs   
1062 0ECD              *** end of leaveScreenOn code
1063 0ECD
1064 0ECD 64 01                 stz   <loading                 ;FALSE for no loading.
1065 0ECF
1066 0ECF A9 B6 12              lda   #buildLoadTable          ;Build hash table of tools that were loaded.
1067 0ED2 20 E2 15              jsr   walkToolArray
1068 0ED5
1069 0ED5
1070 0ED5              ;-----------------------------------------------------------
1071 0ED5              ; 
1072 0ED5              ; Shutdown loop.
1073 0ED5              ;
1074 0ED5 A2 00 00              ldx   #0
1075 0ED8 80 28                 bra   @enter1
1076 0EDA DA           @lop1    phx   
1077 0EDB              ;
1078 0EDB 20 07 13              jsr   checkLoadTable           Check if user wants this tool started.
1079 0EDE 18                    clc                            Make flag correct.
1080 0EDF F0 1B                 beq   @next1
1081 0EE1              ;
1082 0EE1 FA                    plx                            Call shutdown handler.
1083 0EE2 DA                    phx   
1084 0EE3 BD 61 14              lda   |shutdownTable+1,x       Is there a handler?
1085 0EE6 D0 10                 bne   @ok2
1086 0EE8              ;
1087 0EE8 BD 60 14              lda   |shutdownTable,x         Compute shutdown call number.
1088 0EEB 29 FF 00              and   #$00FF
1089 0EEE 09 00 03              ora   #$0300
1090 0EF1 AA                    tax   
1091 0EF2 22 00 00 E1           jsl   $E10000                  Call tool's shutdown, no parameters.
1092 0EF6 80 03                 bra   @enter2
1093 0EF8              ;
1094 0EF8 FC 61 14     @ok2     jsr   (shutdownTable+1,x)
1095 0EFB A8           @enter2  tay                            Possible error code into y.
1096 0EFC FA           @next1   plx   
1097 0EFD B0 29                 bcs   @errOut                  Error?
1098 0EFF              ;
1099 0EFF E8                    inx                            Next tool.
1100 0F00 E8                    inx   
1101 0F01 E8                    inx   
1102 0F02 BD 60 14     @enter1  lda   |shutdownTable,x         Next tool to shutdown.
1103 0F05 29 FF 00              and   #$00FF
1104 0F08 D0 D0                 bne   @lop1                    Any more tools?
1105 0F0A
1106 0F0A
1107 0F0A              ;-----------------------------------------------------------
1108 0F0A              ;
1109 0F0A              ; Dispose of the handle we allocated for direct page.
1110 0F0A              ;
1111 0F0A A0 08 00              ldy   #StartStopRecord.DPageHandle+2
1112 0F0D B7 2C                 lda   [startrec],y
1113 0F0F AA                    tax   
1114 0F10 88                    dey   
1115 0F11 88                    dey   
1116 0F12 B7 2C                 lda   [startrec],y
1117 0F14 20 F4 18              jsr   KillIt
1118 0F17
1119 0F17              ;-----------------------------------------------------------
1120 0F17              ;
1121 0F17              ; If the input to this call is a handle, dispose of it.
1122 0F17              ;
1123 0F17 A5 30                 lda   <StartRecFlag
1124 0F19 29 03 00              and   #3                       ;17-Nov-90 DAL
1125 0F1C F0 07                 beq   @NotHandle
1126 0F1E A5 17                 lda   <handle
1127 0F20 A6 19                 ldx   <handle+2
1128 0F22 20 F4 18              jsr   KillIt
1129 0F25
1130 0F25              @NotHandle  
1131 0F25
1132 0F25              ;-----------------------------------------------------------
1133 0F25              ;
1134 0F25              ; We log off the res mgr last just in case any of the
1135 0F25              ; other tools need the res mgr to shut down.
1136 0F25              ;
1137 0F25
1138 0F25              ;;;	lda	<startRecFlag
1139 0F25              ;;;	and	#skipResMgr
1140 0F25              ;;;	bne	@skipRMSD
1141 0F25              ;;;	_ResourceShutdown		;Log off of Resource Manager.
1142 0F25              ;;;@skipRMSD
1143 0F25
1144 0F25 A0 00 00              ldy   #0                       ;No error.
1145 0F28              ;
1146 0F28              ; @errOut -- Exit
1147 0F28              ;
1148 0F28              @errOut   
1149 0F28
1150 0F28              *** 1-Jul-92 DAL -- Moved ResourceShutDown code here (in error-exit path)
1151 0F28 5A                    phy                            ;save error code
1152 0F29 A5 30                 lda   <startRecFlag
1153 0F2B 29 10 00              and   #skipResMgr
1154 0F2E D0 07                 bne   @skipRMSD
1155 0F30 A2 1E 03 22           _ResourceShutDown 
1156 0F37 7A           @skipRMSD ply                           ;restore error code
1157 0F38              *** end 1-Jul-92
1158 0F38
1159 0F38 A2 06 00              ldx   #6                       ;Number of bytes to strip.
1160 0F3B
1161 0F3B                       entry pop 
1162 0F3B 22 68 00 E1  pop      jsl   DecBusyFlg
1163 0F3F              ;
1164 0F3F              ; --- Restore saved parameters from startupCall.
1165 0F3F              ;
1166 0F3F              ;
1167 0F3F 3B                    tsc                            ;Free allocate direct page in stack.
1168 0F40 18                    clc   
1169 0F41 69 22 00              adc   #saveDbank-1
1170 0F44 1B                    tcs   
1171 0F45
1172 0F45 AB                    plb                            ;Restore original data bank.
1173 0F46
1174 0F46              ;
1175 0F46              ; --- Move return addresses over top of input parameters.
1176 0F46              ;
1177 0F46 3B                    tsc   
1178 0F47 5B                    tcd   
1179 0F48 A3 07                 lda   7,s
1180 0F4A 95 07                 sta   7,x
1181 0F4C A3 05                 lda   5,s
1182 0F4E 95 05                 sta   5,x
1183 0F50 A3 03                 lda   3,s
1184 0F52 95 03                 sta   3,x
1185 0F54
1186 0F54              ;
1187 0F54              ; --- Adjust stact for popped parameters.
1188 0F54              ;
1189 0F54 2B                    pld                            ;Get original direct page pointer.
1190 0F55
1191 0F55 3B                    tsc                            ;Current stack,
1192 0F56 DA                    phx   
1193 0F57 18                    clc   
1194 0F58 63 01                 adc   1,s                      ;plus number of bytes popped,
1195 0F5A 1B                    tcs                            ;equals new stack.
1196 0F5B
1197 0F5B 98                    tya                            ;Return error code in Y.
1198 0F5C C9 01 00              cmp   #1                       ;Set carry if error.
1199 0F5F
1200 0F5F 6B                    rtl   
1201 0F60
1202 0F60
1203 0F60              **********************************************************************
1204 0F60              *
1205 0F60              * This is the shutdown table.  To add a tool to be shutdown 
1206 0F60              * add a record to this table at the position you want it to be shutdown.
1207 0F60              * The first tool shutdown is the first tool in the table.
1208 0F60              * A record is a one byte tool number followed by a one word 
1209 0F60              * address of a routine that shutdown the tool or zero to just call 
1210 0F60              * its shutdown call.  The routine should shutdown the tool and 
1211 0F60              * return carry set if there is an error with an error code in a.
1212 0F60              *
1213 0F60              * Change History
1214 0F60              *
1215 0F60              * 06 Feb 89         Steven Glass
1216 0F60              *
1217 0F60              * Added tool locator to end of list.
1218 0F60              *
1219 0F60              * 17-Nov-90         Dave Lyons
1220 0F60              *
1221 0F60              * Added Media Control, Animation, MidiSynth right after Desk Manager.
1222 0F60              *
1223 0F60              **********************************************************************
1224 0F60              shutdownTable  
1225 0F60 05                    DC B:5                         ;Desk Mgr
1226 0F61 00 00                 DC W:0
1227 0F63 26                    DC B:38                        ;Media Control  (added 17-Nov-90 DAL)
1228 0F64 00 00                 DC W:0                         ;               (added 17-Nov-90 DAL)
1229 0F66 25                    DC B:37                        ;Animation      (added 17-Nov-90 DAL)
1230 0F67 00 00                 DC W:0                         ;               (added 17-Nov-90 DAL)
1231 0F69 23                    DC B:35                        ;MidiSynth      (added 17-Nov-90 DAL)
1232 0F6A 00 00                 DC W:0                         ;               (added 17-Nov-90 DAL)
1233 0F6C 21                    DC B:33                        ;Video Overlay
1234 0F6D 00 00                 DC W:0
1235 0F6F 0A                    DC B:10                        ;SANE
1236 0F70 00 00                 DC W:0
1237 0F72 1D                    DC B:29                        ;ACE
1238 0F73 00 00                 DC W:0
1239 0F75 1A                    DC B:NoteSeq                   ;Note sequencer
1240 0F76 00 00                 DC W:0
1241 0F78 20                    DC B:MIDITools                 ;MIDI
1242 0F79 00 00                 DC W:0
1243 0F7B 19                    DC B:NoteSynth                 ;Note Synth
1244 0F7C 2D 18                 DC W:StopNoteSynth
1245 0F7E 08                    DC B:8                         ;Sound Tool
1246 0F7F 36 18                 DC W:StopSound
1247 0F81 22                    DC B:34                        ;Text Edit
1248 0F82 00 00                 DC W:0
1249 0F84 13                    DC B:19                        ;Print Mgr
1250 0F85 00 00                 DC W:0
1251 0F87 1B                    DC B:27                        ;Font Mgr
1252 0F88 00 00                 DC W:0
1253 0F8A 17                    DC B:23                        ;Standard File
1254 0F8B 24 18                 DC W:stopStdFile
1255 0F8D 15                    DC B:21                        ;Dialog Mgr
1256 0F8E 00 00                 DC W:0
1257 0F90 16                    DC B:22                        ;Scrap Mgr
1258 0F91 00 00                 DC W:0
1259 0F93 14                    DC B:20                        ;Line Edit
1260 0F94 00 00                 DC W:0
1261 0F96 0F                    DC B:15                        ;Menu Mgr
1262 0F97 9C 17                 DC W:stopMenuMgr
1263 0F99 10                    DC B:16                        ;Control Mgr
1264 0F9A 00 00                 DC W:0
1265 0F9C 0E                    DC B:14                        ;Window Manager
1266 0F9D 00 00                 DC W:0
1267 0F9F 06                    DC B:6                         ;Event Mgr
1268 0FA0 00 00                 DC W:0
1269 0FA2 12                    DC B:18                        ;QD Aux
1270 0FA3 00 00                 DC W:0
1271 0FA5 04                    DC B:4                         ;Quick Draw
1272 0FA6 63 17                 DC W:stopQuickDraw
1273 0FA8 03                    DC B:3                         ;Misc. Tools
1274 0FA9 00 00                 DC W:0
1275 0FAB 02                    DC B:2                         ;Memory Manager
1276 0FAC 23 18                 DC W:StopMM
1277 0FAE 1E                    DC B:$1E                       ;Resource Manager 25-Feb-91 DAL
1278 0FAF 23 18                 DC W:StopResMgr                ; (no-op)
1279 0FB1 01                    DC B:1                         ;Tool Locator
1280 0FB2 00 00                 DC W:0
1281 0FB4 00                    DC B:0                         ;(No more tools)
1282 0FB5
1283 0FB5                       ENDP 
1284 0FB5
1285 0FB5
1286 0FB5              ****************************************************************
1287 0FB5              *
1288 0FB5              getStartupPtr PROC 
1289 0FB5              *
1290 0FB5              * Description
1291 0FB5              *
1292 0FB5              *
1293 0FB5              * Inputs:
1294 0FB5              *                   none
1295 0FB5              *
1296 0FB5              * Outputs:
1297 0FB5              *        <handle = handle of startup record, NIL if none.
1298 0FB5              *        <startRec = pointer to startup record.
1299 0FB5              *        Carry set if error, y = error code.
1300 0FB5              *
1301 0FB5              * External Refs:
1302 0FB5                       IMPORT derefHand 
1303 0FB5              *
1304 0FB5              * Entry Points:
1305 0FB5              *                   none
1306 0FB5              *
1307 0FB5                       longa on                       ; mode
1308 0FB5                       longi on
1309 0FB5              *
1310 0FB5              ****************************************************************
1311 0FB5
1312 0FB5              ;;;	ldy	#TLBadRecFlag	;Possible error code.
1313 0FB5 A5 30                 lda   <startRecFlag            ;Dispatch to converter.
1314 0FB7 29 03 00              and   #3                       ;17-Nov-90 DAL
1315 0FBA 0A                    asl   a
1316 0FBB AA                    tax   
1317 0FBC              ;;;	cpx	#5
1318 0FBC              ;;;	bcs	@errOut
1319 0FBC 7C BF 14              jmp   (@converters,x)
1320 0FBF 01 15        @converters DC W:@pointer
1321 0FC1 CC 14                 DC W:@hand
1322 0FC3 D7 14                 DC W:@res
1323 0FC5              *** added 1-Jul-92 DAL
1324 0FC5 C7 14                 DC W:@illegal
1325 0FC7
1326 0FC7 A0 03 01     @illegal ldy   #TLBadRecFlag
1327 0FCA 38                    sec   
1328 0FCB 60                    rts   
1329 0FCC              *** end 1-Jul-92
1330 0FCC              ;
1331 0FCC              ;
1332 0FCC              ; ------ Startup record is a handle.
1333 0FCC              ;
1334 0FCC A5 2C        @hand    lda   <startRec                ;Save handle.
1335 0FCE A6 2E                 ldx   <startRec+2
1336 0FD0 85 17                 sta   <handle
1337 0FD2 86 19                 stx   <handle+2
1338 0FD4 82 46 00              brl   derefHand                ;<startRec = (<handle)
1339 0FD7              ;
1340 0FD7              ;
1341 0FD7              ; ------ Startup record is a resource ID.
1342 0FD7              ;
1343 0FD7 48           @res     pha                            ;Space for result.
1344 0FD8 48                    pha   
1345 0FD9 F4 13 80              pea   rToolStartup             ;Pass resource type of resource startup record.
1346 0FDC D4 2E                 pei   <startRec+2              ;Pass resource ID of resource startup record.
1347 0FDE D4 2C                 pei   <startRec
1348 0FE0 A2 1E 0E 22           _LoadResource 
1349 0FE7 A8                    tay                            ;Put possible error code in y.
1350 0FE8 68                    pla   
1351 0FE9 FA                    plx   
1352 0FEA B0 1E                 bcs   @errOut
1353 0FEC              ;
1354 0FEC 85 17                 sta   <handle
1355 0FEE 86 19                 stx   <handle+2
1356 0FF0              ;
1357 0FF0 F4 13 80              pea   rToolStartup             ;Pass resource type of resource startup record.
1358 0FF3 D4 2E                 pei   <startRec+2              ;Pass resource ID of resource startup record.
1359 0FF5 D4 2C                 pei   <startRec
1360 0FF7 A2 1E 18 22           _DetachResource                ;Let startup record float.
1361 0FFE              ;
1362 0FFE 82 1C 00              brl   derefHand                ;<startRec = (<handle)
1363 1001              ;
1364 1001              ;
1365 1001              ; ------ Startup record is a pointer.
1366 1001              ;
1367 1001 A5 2C        @pointer lda   startRec                 No handle so copy pointer to handle to use
1368 1003 85 17                 sta   <handle                  as output
1369 1005 A5 2E                 lda   startRec+2
1370 1007 85 19                 sta   <handle+2
1371 1009
1372 1009 18                    clc                            No error.
1373 100A 60           @errOut  rts   
1374 100B
1375 100B                       ENDP 
1376 100B
1377 100B
1378 100B              ****************************************************************
1379 100B              *
1380 100B              startCall PROC 
1381 100B              *
1382 100B              * Incs the busy flag, and gets d-page off stack for use
1383 100B              * in call.
1384 100B              *
1385 100B              *
1386 100B              * Inputs:
1387 100B              *                   none
1388 100B              *
1389 100B              * Outputs:
1390 100B              *                   none
1391 100B              *
1392 100B              * External Refs:
1393 100B              *                   none
1394 100B              *
1395 100B              * Entry Points:
1396 100B              *                   none
1397 100B              *
1398 100B                       longa on                       ; mode
1399 100B                       longi on
1400 100B              *
1401 100B              ****************************************************************
1402 100B
1403 100B              ;
1404 100B 22 64 00 E1           jsl   IncBusyFlg
1405 100F              ;
1406 100F FA                    plx                            Get caller's return address.
1407 1010              ;
1408 1010 0B                    phd                            Save caller's direct page pointer.
1409 1011 8B                    phb                            Save caller's data bank pointer.
1410 1012 4B                    phk   
1411 1013 AB                    plb   
1412 1014              ;
1413 1014 3B                    tsc                            Allocate direct page in stack.
1414 1015 38                    sec   
1415 1016 E9 22 00              sbc   #saveDbank-1
1416 1019 1B                    tcs   
1417 101A 5B                    tcd   
1418 101B              ;
1419 101B DA                    phx                            Put return address back.
1420 101C 60                    rts   
1421 101D
1422 101D
1423 101D                       ENDP 
1424 101D
1425 101D
1426 101D              ****************************************************************
1427 101D              *
1428 101D              derefHand PROC 
1429 101D              *
1430 101D              * Derefernce handle of startup record if there is a handle.
1431 101D              *
1432 101D              *
1433 101D              * Inputs:
1434 101D              *                   handle
1435 101D              *
1436 101D              * Outputs:
1437 101D              *                   startRec
1438 101D              *
1439 101D              * External Refs:
1440 101D              *                   none
1441 101D              *
1442 101D              * Entry Points:
1443 101D              *                   none
1444 101D              *
1445 101D                       longa on                       ; mode
1446 101D                       longi on
1447 101D              *
1448 101D              ****************************************************************
1449 101D
1450 101D              ;
1451 101D A5 18                 lda   <handle+1                NIL handle?
1452 101F F0 15                 beq   @exit
1453 1021              ;
1454 1021 A0 04 00              ldy   #4                       Lock the handle  (added 30 Mar 89)
1455 1024 B7 17                 lda   [<handle],y
1456 1026 09 00 80              ora   #$8000
1457 1029 97 17                 sta   [<handle],y
1458 102B
1459 102B A0 02 00              ldy   #2                       Dereference the handle.
1460 102E B7 17                 lda   [<handle],y
1461 1030 85 2E                 sta   <startRec+2
1462 1032 A7 17                 lda   [<handle]
1463 1034 85 2C                 sta   <startRec
1464 1036              ;
1465 1036 18           @exit    clc                            No error.
1466 1037 60                    rts   
1467 1038                       ENDP 
1468 1038
1469 1038
1470 1038
1471 1038              ****************************************************************
1472 1038              *
1473 1038              openAppRes PROC 
1474 1038              *
1475 1038              * Open the application's resource fork.
1476 1038              *
1477 1038              *
1478 1038              * Inputs:
1479 1038              *                   direct page stuff
1480 1038              *
1481 1038              * Outputs:
1482 1038              *                   a-reg = openfile id, NIL if none
1483 1038              *                   SEC = bad error (in Y) (added 1-Jul-92)
1484 1038              *
1485 1038              * External Refs:
1486 1038                       import KillIt 
1487 1038              *
1488 1038              * Entry Points:
1489 1038              *                   none
1490 1038              *
1491 1038                       longa on                       ; mode
1492 1038                       longi on
1493 1038              *
1494 1038              ****************************************************************
1495 1038
1496 1038              *** added 25-Feb-91 DAL
1497 1038 A5 30                 lda   <startRecFlag
1498 103A 29 10 00              and   #skipResMgr
1499 103D F0 03                 beq   @doResMgr
1500 103F 82 9B 00              brl   @errOut
1501 1042              @doResMgr  
1502 1042              *** end of 25-Feb-91 DAL
1503 1042
1504 1042 48                    pha                            ;Is the Resource Manager loaded?
1505 1043 A2 1E 06 22           _ResourceStatus 
1506 104A 68                    pla   
1507 104B 90 03                 bcc   @1
1508 104D 82 8D 00              brl   @errOut
1509 1050              @1        
1510 1050 D4 32                 pei   <userID                  ;Pass user ID.
1511 1052 A2 1E 02 22           _ResourceStartUp               ;Log application in with Resource Manager.
1512 1059              *** added 1-Jul-92 DAL -- Check for an error from ResourceStartUp
1513 1059 90 02                 bcc   @resStarted
1514 105B A8                    tay   
1515 105C              ;	sec
1516 105C 60                    rts   
1517 105D              @resStarted  
1518 105D              *** end 1-Jul-92
1519 105D              ;
1520 105D              ; ------ Get name of application.
1521 105D              ;
1522 105D 48                    pha                            ;Space for result.
1523 105E 48                    pha   
1524 105F F4 00 00              pea   0                        ;Pass number of bytes to allocate.
1525 1062 F4 00 04              pea   1024
1526 1065 D4 32                 pei   <userID                  ;Pass user ID.
1527 1067 F4 00 C0              pea   $C000                    ;Pass attributes, fixed.
1528 106A 48                    pha                            ;Pass address, not used.
1529 106B 48                    pha   
1530 106C A2 02 09 22           _NewHandle 
1531 1073 FA                    plx   
1532 1074 86 17                 stx   <handle
1533 1076 FA                    plx   
1534 1077 86 19                 stx   <handle+2
1535 1079 A8                    tay                            ;Possible error code.
1536 107A B0 61                 bcs   @errOut
1537 107C
1538 107C A0 02 00              ldy   #2                       ;Dereference the handle.
1539 107F B7 17                 lda   [<handle],y
1540 1081 85 13                 sta   <getName+2
1541 1083 A7 17                 lda   [<handle]
1542 1085 85 11                 sta   <getName
1543 1087
1544 1087
1545 1087              *** The New Way:  Use LGetPathname2 on the master UserID passed in
1546 1087
1547 1087 48                    pha   
1548 1088 48                    pha                            ;space for LGetPathname2 result
1549 1089 A5 32                 lda   <UserID
1550 108B 29 FF F0              and   #$f0ff
1551 108E 48                    pha   
1552 108F F4 01 00              pea   1                        ;file number
1553 1092 A2 11 22 22           _LGetPathname2 
1554 1099
1555 1099 68                    pla                            ;anticipate error:
1556 109A B0 35                 bcs   @pathError               ;take branch with ONE word to be pulled
1557 109C 48                    pha                            ;put half of result back on stack
1558 109D
1559 109D 0B                    phd   
1560 109E 3B                    tsc   
1561 109F 5B                    tcd   
1562 10A0 A7 03                 lda   [3]                      ;get length of pathname
1563 10A2 1A                    inc   a
1564 10A3 1A                    inc   a
1565 10A4 2B                    pld   
1566 10A5
1567 10A5              * leave LGetPathname2 result on stack for BlockMove
1568 10A5 D4 13                 pei   <getName+2               ;destination for BlockMove
1569 10A7 D4 11                 pei   <getName
1570 10A9 F4 00 00              pea   0
1571 10AC 48                    pha                            ;length of string
1572 10AD A2 02 2B 22           _BlockMove 
1573 10B4              ;
1574 10B4              ; ------ Open application's resource file.
1575 10B4              ;
1576 10B4 48                    pha                            ;Space for OpenResourceFile result
1577 10B5
1578 10B5              ***	PushWord #1	;Read only access!
1579 10B5              *** 15,18-Feb-91 DAL -- bit 3 of the StartStopRefRef means open res fork "as allowed" instead of read-only
1580 10B5 A5 30                 lda   <startRecFlag
1581 10B7 29 08 00              and   #openResReadWrite
1582 10BA 4A                    lsr   a
1583 10BB 4A                    lsr   a
1584 10BC 4A                    lsr   a
1585 10BD 49 01 00              eor   #1
1586 10C0 48                    pha   
1587 10C1              *** end of 15,18-Feb-91 DAL
1588 10C1
1589 10C1 A9 00 00              lda   #0                       ;Pass map pointer, none.
1590 10C4 48                    pha   
1591 10C5 48                    pha   
1592 10C6 D4 13                 pei   <getName+2               ;Pass pointer to GS/OS input name of application.
1593 10C8 D4 11                 pei   <getName
1594 10CA A2 1E 0A 22           _OpenResourceFile 
1595 10D1
1596 10D1 08           @pathError php                          ;Save result.
1597 10D2
1598 10D2 A6 19                 ldx   <handle+2                ;Free pathname buffer.
1599 10D4 A5 17                 lda   <handle
1600 10D6 20 F4 18              jsr   KillIt
1601 10D9
1602 10D9 28                    plp                            ;Restore status.
1603 10DA 68                    pla                            ;Get file ID returned by OpenResource (or 2nd word of LGetPathname2 result)
1604 10DB 90 03                 bcc   @exit
1605 10DD
1606 10DD A9 00 00     @errOut  lda   #0                       ;Return no open file ID.
1607 10E0 18           @exit    clc                            ;always return from here with CLC, started ResMgr (1-Jul-92)
1608 10E1 60                    rts   
1609 10E2
1610 10E2                       ENDP 
1611 10E2
1612 10E2
1613 10E2
1614 10E2              ****************************************************************
1615 10E2              *
1616 10E2              walkToolArray PROC 
1617 10E2              *
1618 10E2              * Calls the indicated routine for each tool in the array.  The
1619 10E2              * indicated routine is called with following inputs:
1620 10E2              *
1621 10E2              *                   y = index to tool in startup record
1622 10E2              *
1623 10E2              * The output from the routine is the carry flag: set to abort.
1624 10E2              *
1625 10E2              *
1626 10E2              *   IN: 
1627 10E2              *      a =          address of routine to call for each tool in the array.
1628 10E2              *      <startRec =  pointer to start record that contains the tool array.
1629 10E2              *
1630 10E2              *  OUT: 
1631 10E2              *      Carry set if routine aborted walk.
1632 10E2              *      Carry clear if entire list walk.
1633 10E2              *
1634 10E2              *
1635 10E2              * External Refs:
1636 10E2              *                   none
1637 10E2              *
1638 10E2              * Entry Points:
1639 10E2              *                   none
1640 10E2              *
1641 10E2                       longa on                       ; mode
1642 10E2                       longi on
1643 10E2              *
1644 10E2              ****************************************************************
1645 10E2
1646 10E2              @saveToolIndex equ   1
1647 10E2              @saveToolCounter equ   @saveToolIndex+2
1648 10E2              @routine equ   @saveToolCounter+2
1649 10E2
1650 10E2 3A                    dec   a                        ;Make address a return address.
1651 10E3 48                    pha                            ;Save address.
1652 10E4
1653 10E4 A0 0A 00              ldy   #StartStopRecord.NumTools ;Get number of tools in array.
1654 10E7 B7 2C                 lda   [<startRec],y
1655 10E9 AA                    tax   
1656 10EA C8                    iny                            ;Index to first tool.
1657 10EB C8                    iny   
1658 10EC 80 14                 bra   @enter1
1659 10EE
1660 10EE DA           @lop1    phx                            ;Save tool counter.
1661 10EF 5A                    phy                            ;Save tool index.
1662 10F0
1663 10F0 A3 05                 lda   @routine,s
1664 10F2 F4 F8 15              pea   @return-1                ;Put return address on stack.
1665 10F5 48                    pha                            ;Dispatch to routine to call.
1666 10F6 B7 2C                 lda   [<startRec],y            ;Pass tool number.
1667 10F8 60                    rts   
1668 10F9 68           @return  pla   
1669 10FA FA                    plx   
1670 10FB B0 09                 bcs   @exit                    ;Did routine abort?
1671 10FD
1672 10FD 18                    clc                            ;Increment index to next tool element.
1673 10FE 69 04 00              adc   #4
1674 1101 A8                    tay   
1675 1102
1676 1102 CA           @enter1  dex                            ;Any more tools?
1677 1103 10 E9                 bpl   @lop1
1678 1105
1679 1105 18                    clc                            ;Entire array walked flag.
1680 1106 68           @exit    pla                            ;Get rid of return address.
1681 1107 60                    rts   
1682 1108                       ENDP 
1683 1108
1684 1108
1685 1108              ;=====================================================================
1686 1108              ;   Pass pointer to direct page and increment counter.
1687 1108              ;=====================================================================
1688 1108              ;
1689 1108              ;   IN: a = tool number, range already checked.
1690 1108              ;   <directPages = handle of direct pages.
1691 1108              ;   <numPages = next available direct page.
1692 1108              ;
1693 1108              ;  OUT: Pointer to available direct page on stack.
1694 1108              ;   <numPages = next available direct page.
1695 1108              ;
1696 1108              pushDirectPage PROC 
1697 1108
1698 1108                       IMPORT toolTable 
1699 1108
1700 1108 A8                    tay                            ;Save tool number.
1701 1109
1702 1109 FA                    plx                            ;Pull return address.
1703 110A A7 09                 lda   [<directPages]           ;Push pointer to next available direct page.
1704 110C 18                    clc   
1705 110D 65 0D                 adc   <numPages
1706 110F 48                    pha   
1707 1110 DA                    phx                            ;Put return address back.
1708 1111
1709 1111 B9 8F 12              lda   |toolTable,y             ;Increment page counter.
1710 1114 29 7F 00              and   #$007F
1711 1117 EB                    xba   
1712 1118 18                    clc   
1713 1119 65 0D                 adc   <numPages
1714 111B 85 0D                 sta   <numPages
1715 111D 60                    rts   
1716 111E
1717 111E                       ENDP 
1718 111E
1719 111E
1720 111E              ;*************************************************************************************
1721 111E              ;           Tool Startup handlers.
1722 111E              ;*************************************************************************************
1723 111E
1724 111E              ;===========================================
1725 111E              ;   Start Miscellaneous Tools.
1726 111E              ;===========================================
1727 111E
1728 111E              startMiscTools PROC 
1729 111E
1730 111E A2 03 02 22           _MTStartup 
1731 1125 60                    rts   
1732 1126                       ENDP 
1733 1126
1734 1126
1735 1126              ;===========================================
1736 1126              ;   Start QuickDraw.
1737 1126              ;===========================================
1738 1126
1739 1126              startQuickDraw PROC 
1740 1126
1741 1126                       IMPORT pushDirectPage 
1742 1126
1743 1126 A9 04 00              lda   #4                       ;Pass address of QuickDraw's direct pages.
1744 1129 20 08 16              jsr   pushDirectPage
1745 112C A0 02 00              ldy   #StartStopRecord.VideoMode ;Pass video mode to start in.
1746 112F B7 2C                 lda   [<startRec],y
1747 1131 48                    pha   
1748 1132              *** added 20-Nov-90 DAL: If we're starting the Window Manager too, don't clear the screen
1749 1132 A9 0E 00              lda   #14                      ;window manager
1750 1135 20 07 13              jsr   checkLoadTable
1751 1138 F0 05                 beq   @noWM
1752 113A 68                    pla   
1753 113B 09 00 01              ora   #$0100                   ;force bit $0100 on in the MasterSCB word
1754 113E 48                    pha   
1755 113F              @noWM     
1756 113F              *** end of 20-Nov-90 DAL
1757 113F F4 A0 00              pea   160                      ;Pass bytes per scan line.
1758 1142 D4 32                 pei   <userID                  ;Pass user ID.
1759 1144 A2 04 02 22           _QDStartup 
1760 114B B0 10                 bcs   @errOut2
1761 114D
1762 114D              *** added 25-Feb-91 DAL: If we're starting the Event Mgr too, don't show the cursor yet
1763 114D A9 06 00              lda   #6
1764 1150 20 07 13              jsr   checkLoadTable
1765 1153 D0 07                 bne   @doingEM
1766 1155              ***
1767 1155 A2 04 91 22           _ShowCursor                    ;Turn on cursor.
1768 115C 18           @doingEM clc   
1769 115D 60           @errOut2 rts   
1770 115E                       ENDP 
1771 115E
1772 115E
1773 115E              ;===========================================
1774 115E              ;   Start QuickDraw Aux.
1775 115E              ;===========================================
1776 115E
1777 115E              startQDAux PROC 
1778 115E
1779 115E A2 12 02 22           _QDAuxStartup 
1780 1165 A2 12 0A 22           _WaitCursor 
1781 116C
1782 116C 60                    rts   
1783 116D                       ENDP 
1784 116D
1785 116D
1786 116D              ;===========================================
1787 116D              ;   Start Event Manager.
1788 116D              ;===========================================
1789 116D
1790 116D              startEventMgr PROC 
1791 116D
1792 116D                       IMPORT pushDirectPage 
1793 116D
1794 116D A9 06 00              lda   #6                       ;pointer to Event Manager direct page.
1795 1170 20 08 16              jsr   pushDirectPage
1796 1173 F4 14 00              pea   20                       ;queue size.
1797 1176 F4 00 00              pea   0                        ;minimum x mouse clamp.
1798 1179 A2 80 02              ldx   #640
1799 117C A0 02 00              ldy   #StartStopRecord.VideoMode ;video mode to start in.
1800 117F B7 2C                 lda   [<startRec],y
1801 1181              ***	and	#$00FF	;Added by DDG to fix shadowed QD bug
1802 1181 29 80 00              and   #$0080                   ;changed from $ff to $80 17-Nov-90 DAL
1803 1184 D0 03                 bne   @okEM
1804 1186 A2 40 01              ldx   #320
1805 1189 DA           @okEM    phx                            ;maximum x mouse clamp.
1806 118A F4 00 00              pea   0                        ;minimum y mouse clamp.
1807 118D F4 C8 00              pea   200                      ;maximum y mouse clamp.
1808 1190 D4 32                 pei   <userID                  ;application's user ID.
1809 1192 A2 06 02 22           _EMStartup 
1810 1199 B0 10                 bcs   @outtahere
1811 119B              *** 25-Feb-91 DAL: If we started QD too, do a ShowCursor now
1812 119B A9 04 00              lda   #4
1813 119E 20 07 13              jsr   checkLoadTable
1814 11A1 F0 07                 beq   @noQD
1815 11A3 A2 04 91 22           _ShowCursor 
1816 11AA 18           @noQD    clc   
1817 11AB              ***
1818 11AB 60           @outtahere rts   
1819 11AC
1820 11AC                       ENDP 
1821 11AC
1822 11AC
1823 11AC              ;===========================================
1824 11AC              ;   Start Window Manager.
1825 11AC              ;===========================================
1826 11AC
1827 11AC              startWindowMgr PROC 
1828 11AC
1829 11AC D4 32                 pei   <userID                  ;Pass application's user ID.
1830 11AE A2 0E 02 22           _WindStartup 
1831 11B5 B0 16                 bcs   @toerrOut2
1832 11B7
1833 11B7 A9 0F 00              lda   #15                      ;Menu Manager too?   21-Nov-90 DAL
1834 11BA 20 07 13              jsr   checkLoadTable           ; (Refresh *after* MenuStartUp if we can!)
1835 11BD 18                    clc                            ;
1836 11BE D0 0D                 bne   @toerrOut2               ;
1837 11C0
1838 11C0 F4 00 00              pea   0                        ;Pass 'entire screen' flag.
1839 11C3 F4 00 00              pea   0
1840 11C6 A2 0E 39 22           _RefreshDesktop                ;Draw screen.
1841 11CD 60           @toerrOut2 rts   
1842 11CE                       ENDP 
1843 11CE
1844 11CE
1845 11CE              ;===========================================
1846 11CE              ;   Start Control Manager.
1847 11CE              ;===========================================
1848 11CE
1849 11CE              startControlMgr PROC 
1850 11CE
1851 11CE                       IMPORT pushDirectPage 
1852 11CE
1853 11CE D4 32                 pei   <userID                  ;Pass application's user ID.
1854 11D0 A9 10 00              lda   #16                      ;Pass pointer to Control Manager direct page.
1855 11D3 20 08 16              jsr   pushDirectPage
1856 11D6 A2 10 02 22           _CtlStartup 
1857 11DD 60                    rts   
1858 11DE                       ENDP 
1859 11DE
1860 11DE
1861 11DE              ;===========================================
1862 11DE              ;   Start Menu Manager.
1863 11DE              ;===========================================
1864 11DE
1865 11DE              startMenuMgr PROC 
1866 11DE
1867 11DE                       IMPORT pushDirectPage 
1868 11DE
1869 11DE D4 32                 pei   <userID                  ;Pass application's user ID.
1870 11E0 A9 0F 00              lda   #15                      ;Pass pointer to direct page.
1871 11E3 20 08 16              jsr   pushDirectPage
1872 11E6 A2 0F 02 22           _MenuStartup 
1873 11ED B0 0D                 bcs   @1
1874 11EF
1875 11EF F4 00 00              pea   0                        ;added 21-Nov-90 DAL
1876 11F2 F4 00 00              pea   0
1877 11F5 A2 0E 39 22           _RefreshDesktop 
1878 11FC
1879 11FC 60           @1       rts   
1880 11FD                       ENDP 
1881 11FD
1882 11FD
1883 11FD              ;===========================================
1884 11FD              ;   Start Dialog Manager.
1885 11FD              ;===========================================
1886 11FD
1887 11FD              startDialog PROC 
1888 11FD
1889 11FD D4 32                 pei   <userID                  ;Pass application's user ID.
1890 11FF A2 15 02 22           _DialogStartup 
1891 1206 60                    rts   
1892 1207                       ENDP 
1893 1207
1894 1207
1895 1207              ;===========================================
1896 1207              ;   Start Line Edit.
1897 1207              ;===========================================
1898 1207
1899 1207              startLineEdit PROC 
1900 1207
1901 1207                       IMPORT pushDirectPage 
1902 1207
1903 1207 D4 32                 pei   <userID                  ;Pass application's user ID.
1904 1209 A9 14 00              lda   #20                      ;Pass pointer to direct page.
1905 120C 20 08 16              jsr   pushDirectPage
1906 120F A2 14 02 22           _LEStartup 
1907 1216 60                    rts   
1908 1217                       ENDP 
1909 1217
1910 1217
1911 1217              ;===========================================
1912 1217              ;   Start Standard File.
1913 1217              ;===========================================
1914 1217
1915 1217              startStandardFile PROC 
1916 1217
1917 1217                       IMPORT pushDirectPage 
1918 1217
1919 1217 D4 32                 pei   <userID                  ;Pass application's user ID.
1920 1219 A9 17 00              lda   #23                      ;Pass pointer to direct page.
1921 121C 20 08 16              jsr   pushDirectPage
1922 121F A2 17 02 22           _SFStartup 
1923 1226 60                    rts   
1924 1227                       ENDP 
1925 1227
1926 1227
1927 1227              ;===========================================
1928 1227              ;   Start Desk Manager.
1929 1227              ;===========================================
1930 1227
1931 1227              startDeskMgr PROC 
1932 1227 A2 05 02 22           _DeskStartup 
1933 122E 60                    rts   
1934 122F                       ENDP 
1935 122F
1936 122F
1937 122F              ;===========================================
1938 122F              ;   Start Resource Manager (no-op)
1939 122F              ;===========================================
1940 122F
1941 122F              startResMgr PROC 
1942 122F 18                    clc   
1943 1230 60                    rts   
1944 1231                       ENDP 
1945 1231
1946 1231
1947 1231              ;===========================================
1948 1231              ;   Start Scrap Manager.
1949 1231              ;===========================================
1950 1231
1951 1231              startScrap PROC 
1952 1231 A2 16 02 22           _ScrapStartup 
1953 1238 60                    rts   
1954 1239                       ENDP 
1955 1239
1956 1239
1957 1239              ;===========================================
1958 1239              ;   Start Sound Tool.
1959 1239              ;                   8 dec 88 Modified to check for note seq startup - Mensch
1960 1239              ;===========================================
1961 1239
1962 1239              startSound PROC 
1963 1239
1964 1239                       IMPORT pushDirectPage 
1965 1239
1966 1239 A5 1F                 lda   <UtilFlags               ;first test to see if we are going to start the seq
1967 123B 29 04 00              and   #WantsSeq
1968 123E D0 0D                 bne   @done                    ;if so, then skip NoteSynth startup
1969 1240 A9 08 00              lda   #8                       ;Pass pointer to direct page.
1970 1243 20 08 16              jsr   pushDirectPage
1971 1246 A2 08 02 22           _SoundStartup 
1972 124D              @done     
1973 124D 60                    rts   
1974 124E                       ENDP 
1975 124E
1976 124E
1977 124E              ;===========================================
1978 124E              ;   Start Note Synth Tool.
1979 124E              ;                   8 dec 88 Added - Mensch
1980 124E              ;===========================================
1981 124E
1982 124E              startNoteSynth PROC 
1983 124E
1984 124E                       IMPORT pushDirectPage 
1985 124E
1986 124E A5 1F                 lda   <UtilFlags               ;first test to see if we are going to start the seq
1987 1250 29 04 00              and   #WantsSeq
1988 1253 D0 0D                 bne   @done                    ;if so, then skip NoteSynth startup
1989 1255
1990 1255 A9 00 00              lda   #0
1991 1258 48                    pha                            ;default update rate
1992 1259 48                    pha                            ;no user update rtn
1993 125A 48                    pha   
1994 125B A2 19 02 22           _NSStartUp 
1995 1262              @done     
1996 1262 60                    rts   
1997 1263                       ENDP 
1998 1263
1999 1263
2000 1263              ;============================================
2001 1263              ;    Stop QuickDraw
2002 1263              ;                   19-Nov-90 Dave Lyons -- added
2003 1263              ;
2004 1263              ; Calls QDShutDown, but first we set bit $0100
2005 1263              ; of the MasterSCB if we should leave the SHR
2006 1263              ; screen turned on.
2007 1263              ;
2008 1263              ;============================================
2009 1263              stopQuickDraw proc 
2010 1263 A5 30                 lda   <startRecFlag
2011 1265 29 24 00              and   #leaveScreenOn+leaveScreenIntact
2012 1268 F0 2A                 beq   @1
2013 126A 48                    pha   
2014 126B A2 04 17 22           _GetMasterSCB 
2015 1272 68                    pla   
2016 1273 09 00 01              ora   #$0100
2017 1276 48                    pha   
2018 1277 A2 04 16 22           _SetMasterSCB 
2019 127E
2020 127E 48                    pha   
2021 127F A2 04 17 22           _GetMasterSCB 
2022 1286 A2 04 14 22           _SetAllSCBS                    ;experimental 21-Nov-90 DAL (Andy N was whining for this)
2023 128D
2024 128D A2 04 90 22           _HideCursor 
2025 1294 A2 04 03 22  @1       _QDShutDown 
2026 129B 60                    rts   
2027 129C
2028 129C
2029 129C              ;============================================
2030 129C              ;    Stop Menu Manager
2031 129C              ;                   21-Feb-91 Dave Lyons -- added
2032 129C              ;
2033 129C              ; Checks the leaveScreenIntact flag in startRecFlag.
2034 129C              ; If clear, we wipe out the menu bar before
2035 129C              ; calling MenuShutDown.
2036 129C              ;
2037 129C              ;============================================
2038 129C              stopMenuMgr proc 
2039 129C A5 30                 lda   <startRecFlag
2040 129E 29 04 00              and   #leaveScreenIntact
2041 12A1 D0 78                 bne   @noWipe
2042 12A3
2043 12A3 48                    pha   
2044 12A4 48                    pha   
2045 12A5 A2 04 1C 22           _GetPort                       ;preserve old port
2046 12AC 48                    pha   
2047 12AD 48                    pha   
2048 12AE A2 0F 1B 22           _GetMenuMgrPort 
2049 12B5 A2 04 1B 22           _SetPort                       ;set menu manager port
2050 12BC
2051 12BC 48                    pha   
2052 12BD 48                    pha   
2053 12BE A2 0F 11 22           _GetSysBar 
2054 12C5 0B                    phd                            ;dereference system menu bar handle
2055 12C6 3B                    tsc   
2056 12C7 5B                    tcd   
2057 12C8 A0 02 00              ldy   #2
2058 12CB B7 03                 lda   [3],y
2059 12CD AA                    tax   
2060 12CE A7 03                 lda   [3]
2061 12D0 18                    clc                            ;add 8 (offset to rectangle)
2062 12D1 69 08 00              adc   #8
2063 12D4 85 03                 sta   3
2064 12D6 90 01                 bcc   @1
2065 12D8 E8                    inx   
2066 12D9 86 05        @1       stx   5                        ;deference system menu bar
2067 12DB
2068 12DB A0 08 00              ldy   #8                       ;offset past rectangle to flags
2069 12DE B7 03                 lda   [3],y
2070 12E0 29 80 00              and   #$0080                   ;menu bar invisible?
2071 12E3 D0 2C                 bne   @menuBarInvis
2072 12E5
2073 12E5 A0 06 00              ldy   #6
2074 12E8 B7 03        @pushrect lda   [3],y
2075 12EA 48                    pha   
2076 12EB 88                    dey   
2077 12EC 88                    dey   
2078 12ED 10 F9                 bpl   @pushrect
2079 12EF
2080 12EF 3B                    tsc   
2081 12F0 1A                    inc   a
2082 12F1 F4 00 00              pea   0
2083 12F4 48                    pha                            ;pushed rectangle pointer for EraseRect
2084 12F5 F4 00 00              pea   0
2085 12F8 48                    pha                            ;push rectangle pointer again for InsetRect
2086 12F9 F4 02 00              pea   2                        ;horizontal inset
2087 12FC F4 01 00              pea   1                        ;vertical inset
2088 12FF A2 04 4C 22           _InsetRect 
2089 1306 A2 04 55 22           _EraseRect 
2090 130D
2091 130D 68                    pla   
2092 130E 68                    pla   
2093 130F 68                    pla   
2094 1310 68                    pla                            ;pulled rectangle
2095 1311
2096 1311 2B           @menuBarInvis pld                       ;restore direct page
2097 1312 68                    pla   
2098 1313 68                    pla                            ;pull dereferenced value
2099 1314
2100 1314 A2 04 1B 22           _SetPort                       ;restore old port
2101 131B A2 0F 03 22  @nowipe  _MenuShutDown 
2102 1322 60                    rts   
2103 1323
2104 1323
2105 1323              ;============================================
2106 1323              ;    Stop MM (Memory Manager).
2107 1323              ;                   11 Apr 89 added - Glass
2108 1323              ; Does nothing.
2109 1323              ;============================================
2110 1323              StopResMgr proc 
2111 1323                       EndP 
2112 1323              StopMM   PROC 
2113 1323 60                    rts   
2114 1324                       ENDP 
2115 1324
2116 1324              ;============================================
2117 1324              ; Stop Standard File
2118 1324              ;   New routine 17-Mar-92 DAL to tolerate error
2119 1324              ;============================================
2120 1324              stopStdFile proc 
2121 1324 A2 17 03 22           _SFShutDown 
2122 132B 18                    clc   
2123 132C 60                    rts   
2124 132D                       EndP 
2125 132D
2126 132D
2127 132D              ;============================================
2128 132D              ;    Stop Note synth Tool.
2129 132D              ;                   9 dec 88 added - Mensch
2130 132D              ;============================================
2131 132D              StopNoteSynth Proc 
2132 132D A2 19 03 22           _NSShutDown                    ;shut down note synth and ignore errors
2133 1334 18                    clc                            ;they mean nothing since only error is not started
2134 1335 60                    rts   
2135 1336
2136 1336
2137 1336              ;============================================
2138 1336              ;    Stop Sound Tools
2139 1336              ;                   9 dec 88 added - mensch
2140 1336              ;============================================
2141 1336              StopSound Proc 
2142 1336 A2 08 03 22           _SoundShutDown                 ;ignore errors here
2143 133D 18                    clc   
2144 133E 60                    rts   
2145 133F
2146 133F
2147 133F              ;===========================================
2148 133F              ;   Start MIDI tools.
2149 133F              ;                   8 dec 88 Added - Mensch
2150 133F              ;===========================================
2151 133F              startMIDI PROC 
2152 133F
2153 133F                       IMPORT pushDirectPage 
2154 133F
2155 133F D4 32                 pei   <userID                  ;Pass application's user ID.
2156 1341 A9 20 00              lda   #32                      ;Pass pointer to direct page.
2157 1344 20 08 16              jsr   pushDirectPage
2158 1347 A2 20 02 22           _MIDIStartup 
2159 134E
2160 134E 60                    rts   
2161 134F                       ENDP 
2162 134F
2163 134F
2164 134F              ;===========================================
2165 134F              ;   Start NOTE sequencer.
2166 134F              ;                   8 dec 88 Added - Mensch
2167 134F              ;===========================================
2168 134F              startNoteSeq PROC 
2169 134F
2170 134F                       IMPORT pushDirectPage 
2171 134F
2172 134F A9 1A 00              lda   #26                      ;Pass pointer to direct page.
2173 1352 20 08 16              jsr   pushDirectPage
2174 1355 A5 1F                 lda   <UtilFlags               ;see if the user wanted MIDI started up
2175 1357 29 08 00              and   #WantsMIDI
2176 135A F0 03                 beq   @SNS0010                 ;if not then just push a zero for MODE
2177 135C A9 00 80              lda   #$8000                   ;if MIDI then set high bit of MODE
2178 135F 48           @SNS0010 pha                            ;push the mode
2179 1360 F4 00 00              pea   $0000                    ;use the standard update rate
2180 1363 F4 14 00              pea   #20                      ;use 20 as the standard increment
2181 1366 A2 1A 02 22           _SeqStartup 
2182 136D B0 07                 bcs   @SNSErr
2183 136F A2 1A 14 22           _StopInts                      ;turn off sequencer interupts for now
2184 1376              @SNSErr   
2185 1376 60                    rts   
2186 1377                       ENDP 
2187 1377
2188 1377
2189 1377              ;===========================================
2190 1377              ;   Start ACE.
2191 1377              ;                   8 dec 88 added - Mensch
2192 1377              ;===========================================
2193 1377
2194 1377              startACE PROC 
2195 1377
2196 1377                       IMPORT pushDirectPage 
2197 1377
2198 1377              *** Note that this doesn't call ACEInfo to see how much DP space we need.  17-Nov-90 DAL
2199 1377
2200 1377 A9 1D 00              lda   #29                      ;Pass pointer to direct page.
2201 137A 20 08 16              jsr   pushDirectPage
2202 137D A2 1D 02 22           _ACEStartup 
2203 1384
2204 1384 60                    rts   
2205 1385                       ENDP 
2206 1385
2207 1385              ;===========================================
2208 1385              ;   Start SANE.
2209 1385              ;===========================================
2210 1385
2211 1385              startSANE PROC 
2212 1385
2213 1385                       IMPORT pushDirectPage 
2214 1385
2215 1385 A9 0A 00              lda   #10                      ;Pass pointer to direct page.
2216 1388 20 08 16              jsr   pushDirectPage
2217 138B A2 0A 02 22           _SANEStartup 
2218 1392 60                    rts   
2219 1393                       ENDP 
2220 1393
2221 1393              ;===========================================
2222 1393              ;   Start Pokey.
2223 1393              ;===========================================
2224 1393
2225 1393              startPokey PROC 
2226 1393
2227 1393 A2 21 02              ldx   #$0221                   ; _StartVideoMix
2228 1396 22 00 00 E1           jsl   $E10000
2229 139A 60                    rts   
2230 139B
2231 139B                       ENDP 
2232 139B
2233 139B              ;===========================================
2234 139B              ;   Start Print Manager.
2235 139B              ;===========================================
2236 139B
2237 139B              startPrintMgr PROC 
2238 139B
2239 139B                       IMPORT pushDirectPage 
2240 139B
2241 139B D4 32                 pei   <userID                  ;Pass application's user ID.
2242 139D A9 13 00              lda   #19                      ;Pass pointer to direct page.
2243 13A0 20 08 16              jsr   pushDirectPage
2244 13A3 A2 13 02 22           _PMStartup 
2245 13AA 60                    rts   
2246 13AB                       ENDP 
2247 13AB
2248 13AB
2249 13AB              ;===========================================
2250 13AB              ;   Start Font Manager.
2251 13AB              ;===========================================
2252 13AB
2253 13AB              startFont PROC 
2254 13AB
2255 13AB D4 32                 pei   <userID                  ;Pass application's user ID.
2256 13AD A9 1B 00              lda   #27                      ;Pass pointer to direct page.
2257 13B0 20 08 16              jsr   pushDirectPage
2258 13B3 A2 1B 02 22           _FMStartup 
2259 13BA 60                    rts   
2260 13BB                       ENDP 
2261 13BB
2262 13BB              ;===========================================
2263 13BB              ;   Start Text Edit.
2264 13BB              ;===========================================
2265 13BB
2266 13BB              startTextEdit PROC 
2267 13BB
2268 13BB                       IMPORT pushDirectPage 
2269 13BB
2270 13BB D4 32                 pei   <userID                  ;Pass application's user ID.
2271 13BD A9 22 00              lda   #34                      ;Pass pointer to direct page.
2272 13C0 20 08 16              jsr   pushDirectPage
2273 13C3 A2 22 02 22           _TEStartup 
2274 13CA 60                    rts   
2275 13CB                       ENDP 
2276 13CB
2277 13CB              ;===========================================
2278 13CB              ;   StartMidiSynth
2279 13CB              ;===========================================
2280 13CB              ;(Added 17-Nov-90 DAL)
2281 13CB
2282 13CB              startMidiSynth PROC 
2283 13CB
2284 13CB A2 23 02              ldx   #$0223                   ;_MidiSynthStartUp, or whatever it's called
2285 13CE 22 00 00 E1           jsl   $e10000
2286 13D2 60                    rts   
2287 13D3                       ENDP 
2288 13D3
2289 13D3
2290 13D3              ;===========================================
2291 13D3              ;   StartAnimation
2292 13D3              ;===========================================
2293 13D3              ;(Added 17-Nov-90 DAL)
2294 13D3
2295 13D3              startAnimation PROC 
2296 13D3
2297 13D3                       IMPORT pushDirectPage 
2298 13D3
2299 13D3 D4 32                 pei   <userID                  ;push the user ID!  19-Feb-91 DAL
2300 13D5
2301 13D5 A9 25 00              lda   #37                      ;Pass pointer to direct page.
2302 13D8 20 08 16              jsr   pushDirectPage
2303 13DB A9 00 00              lda   #0
2304 13DE 48                    pha                            ;ModeFlag=0
2305 13DF 48                    pha                            ;added 4-Dec-90 DAL (ModeFlag is really a LONG)
2306 13E0 48                    pha                            ;PatchTable=NIL
2307 13E1 48                    pha                            ;PatchTable=NIL
2308 13E2 A2 25 02              ldx   #$0225                   ;_AnimStartUp
2309 13E5 22 00 00 E1           jsl   $e10000
2310 13E9 60                    rts   
2311 13EA                       ENDP 
2312 13EA
2313 13EA
2314 13EA              ;===========================================
2315 13EA              ;   StartMediaCtl
2316 13EA              ;===========================================
2317 13EA              ;(Added 17-Nov-90 DAL)
2318 13EA
2319 13EA              startMediaCtl PROC 
2320 13EA
2321 13EA                       IMPORT pushDirectPage 
2322 13EA
2323 13EA D4 32                 pei   <userID                  ;Pass application's user ID.
2324 13EC A2 26 02              ldx   #$0226                   ;_MCStartUp
2325 13EF 22 00 00 E1           jsl   $e10000
2326 13F3 60                    rts   
2327 13F4                       ENDP 
2328 13F4
2329 13F4
2330 13F4              ****************************************************************
2331 13F4              *
2332 13F4              * Central handle disposing routine.  Inputs handle in a & x
2333 13F4              *
2334 13F4              *
2335 13F4              * Inputs:
2336 13F4              *                   a-reg low word of handle
2337 13F4              *                   x-reg high word of handle
2338 13F4              *
2339 13F4              * Outputs:
2340 13F4              *                   a-reg error code
2341 13F4              *                   carry error condition
2342 13F4              *
2343 13F4              * External Refs:
2344 13F4              *                   none
2345 13F4              *
2346 13F4              * Entry Points:
2347 13F4              *                   none
2348 13F4              *
2349 13F4                       longa on                       ; mode
2350 13F4                       longi on
2351 13F4              *
2352 13F4              ****************************************************************
2353 13F4
2354 13F4              KillIt   PROC 
2355 13F4 DA                    phx   
2356 13F5 48                    pha   
2357 13F6 A2 02 10 22           _DisposeHandle 
2358 13FD 60                    rts   
2359 13FE                       ENDP 
2360 13FE
2361 13FE
2362 13FE                       END   
